/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.VPNConnector;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.ImageHyperlink;
import org.netxms.nxmc.base.widgets.events.IHyperlinkListener;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.AddSubnetDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.SubnetComparator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class VPNSubnets
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(VPNSubnets.class);
    private VPNConnector connector;
    private ObjectSelector objectSelector;
    private TableViewer localNetworksList;
    private TableViewer remoteNetworksList;
    private boolean modified = false;
    private List<InetAddressEx> localNetworksElements;
    private List<InetAddressEx> remoteNetworksElements;

    public VPNSubnets(AbstractObject object) {
        super(i18n.tr("Subnets"), object);
    }

    public String getId() {
        return "vpnSubnets";
    }

    public int getPriority() {
        return 15;
    }

    public boolean isVisible() {
        return this.object instanceof VPNConnector;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.connector = (VPNConnector)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        dialogArea.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        this.objectSelector.setLabel(i18n.tr("Peer gateway"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.connector.getPeerGatewayId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.objectSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite clientArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        gd = new GridData();
        clientArea.setLayout((Layout)layout);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gd);
        this.localNetworksElements = new ArrayList(this.connector.getLocalSubnets());
        this.remoteNetworksElements = new ArrayList(this.connector.getRemoteSubnets());
        this.createNetworkList(clientArea, i18n.tr("Local networks"), this.localNetworksList, this.localNetworksElements);
        this.createNetworkList(clientArea, i18n.tr("Remote networks"), this.remoteNetworksList, this.remoteNetworksElements);
        return dialogArea;
    }

    private void createNetworkList(Composite dialogArea, String title, TableViewer viewList, List<InetAddressEx> data) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText(title);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gd = new GridData();
        clientArea.setLayout((Layout)layout);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        clientArea.setLayoutData((Object)gd);
        viewList = new TableViewer((Composite)clientArea, 67586);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalSpan = 2;
        gd.heightHint = 100;
        viewList.getTable().setLayoutData((Object)gd);
        viewList.getTable().setSortDirection(128);
        viewList.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewList.setComparator((ViewerComparator)new SubnetComparator());
        viewList.setInput((Object)data.toArray());
        TableViewer list = viewList;
        ImageHyperlink linkAdd = new ImageHyperlink((Composite)clientArea, 0);
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageHyperlink linkRemove = new ImageHyperlink((Composite)clientArea, 0);
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addTargetAddressListElement(TableViewer elementList, List<InetAddressEx> elements) {
        InetAddressEx subnet;
        AddSubnetDialog dlg = new AddSubnetDialog(this.getShell());
        if (dlg.open() == 0 && !elements.contains(subnet = dlg.getSubnet())) {
            elements.add(subnet);
            elementList.setInput((Object)elements.toArray());
            this.modified = true;
        }
    }

    private void removeTargetAddressListElements(TableViewer elementList, List<InetAddressEx> elements) {
        IStructuredSelection selection = (IStructuredSelection)elementList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                elements.remove(o);
            }
            elementList.setInput((Object)elements.toArray());
            this.modified = true;
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.modified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.connector.getObjectId());
        md.setVpnNetworks(this.localNetworksElements, this.remoteNetworksElements);
        md.setPeerGatewayId(this.objectSelector.getObjectId());
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

