/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets.helpers;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class ObjectLabelDecorator
implements ILabelDecorator {
    private Map<Image, Image[]> imageCache = new HashMap();

    public Image decorateImage(Image image, Object element) {
        if (image == null || !(element instanceof AbstractObject)) {
            return null;
        }
        AbstractObject object = (AbstractObject)element;
        if (object.getStatus() == ObjectStatus.NORMAL) {
            return null;
        }
        Image[] decoratedImages = (Image[])this.imageCache.get(image);
        int index = object.getStatus().getValue();
        if (decoratedImages != null) {
            if (decoratedImages[index] != null) {
                return decoratedImages[index];
            }
        } else {
            decoratedImages = new Image[9];
            this.imageCache.put(image, decoratedImages);
        }
        DecorationOverlayIcon icon = new DecorationOverlayIcon(image, StatusDisplayInfo.getStatusOverlayImageDescriptor((ObjectStatus)object.getStatus()), 3);
        decoratedImages[index] = icon.createImage();
        return decoratedImages[index];
    }

    public String decorateText(String text, Object element) {
        if (((AbstractObject)element).isInMaintenanceMode()) {
            return text + " [Maintenance]";
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Iterator iterator = this.imageCache.values().iterator();
        while (iterator.hasNext()) {
            Image[] images;
            for (Image image : images = (Image[])iterator.next()) {
                if (image == null) continue;
                image.dispose();
            }
        }
    }
}

