/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.views;

import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.CopyTableRowsAction;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.Activator;
import org.netxms.ui.eclipse.topology.Messages;
import org.netxms.ui.eclipse.topology.views.helpers.FDBComparator;
import org.netxms.ui.eclipse.topology.views.helpers.FDBLabelProvider;
import org.netxms.ui.eclipse.topology.views.helpers.SwitchForwardingDatabaseFilter;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SwitchForwardingDatabaseView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.topology.views.SwitchForwardingDatabaseView";
    public static final int COLUMN_MAC_ADDRESS = 0;
    public static final int COLUMN_PORT = 1;
    public static final int COLUMN_INTERFACE = 2;
    public static final int COLUMN_VLAN = 3;
    public static final int COLUMN_NODE = 4;
    public static final int COLUMN_TYPE = 5;
    private NXCSession session;
    private long rootObject;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionShowFilter;
    private Action actionCopyRowToClipboard;
    private Action actionCopyMACToClipboard;
    private Composite resultArea;
    private FilterText filterText;
    private SwitchForwardingDatabaseFilter filter;
    private boolean initShowFilter = true;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.rootObject = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            this.rootObject = 0L;
        }
        this.session = ConsoleSharedData.getSession();
        Messages.get();
        this.setPartName(String.format(Messages.SwitchForwardingDatabaseView_Title, this.session.getObjectName(this.rootObject)));
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = SwitchForwardingDatabaseView.safeCast(settings.get("SwitchForwardingDatabase.showFilter"), settings.getBoolean("SwitchForwardingDatabase.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.resultArea = new Composite(parent, 2048);
        FormLayout formLayout = new FormLayout();
        this.resultArea.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.resultArea, 2048);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwitchForwardingDatabaseView.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                SwitchForwardingDatabaseView.this.enableFilter(false);
                SwitchForwardingDatabaseView.this.actionShowFilter.setChecked(SwitchForwardingDatabaseView.this.initShowFilter);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.SwitchForwardingDatabaseView_ColMacAddr;
        Messages.get();
        stringArray[1] = Messages.SwitchForwardingDatabaseView_ColPort;
        Messages.get();
        stringArray[2] = Messages.SwitchForwardingDatabaseView_ConIface;
        Messages.get();
        stringArray[3] = Messages.SwitchForwardingDatabaseView_ColVlan;
        Messages.get();
        stringArray[4] = Messages.SwitchForwardingDatabaseView_ColNode;
        Messages.get();
        stringArray[5] = Messages.SwitchForwardingDatabaseView_ColType;
        String[] names = stringArray;
        int[] widths = new int[]{180, 100, 200, 100, 250, 110};
        this.viewer = new SortableTableViewer(this.resultArea, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FDBLabelProvider());
        this.viewer.setComparator((ViewerComparator)new FDBComparator());
        this.filter = new SwitchForwardingDatabaseFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"SwitchForwardingDatabase");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)SwitchForwardingDatabaseView.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"SwitchForwardingDatabase");
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.activateContext();
        this.refresh();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.topology.context.Topology");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.resultArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void dispose() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SwitchForwardingDatabase.showFilter", this.initShowFilter);
        super.dispose();
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SwitchForwardingDatabaseView.this.refresh();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionCopyRowToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        Messages.get();
        this.actionCopyMACToClipboard = new Action(Messages.SwitchForwardingDatabaseView_ActionCopyValue){

            public void run() {
                TableItem[] selection = SwitchForwardingDatabaseView.this.viewer.getTable().getSelection();
                StringBuilder macAddress = new StringBuilder();
                TableItem[] tableItemArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    if (macAddress.length() > 0) {
                        macAddress.append('\t');
                    }
                    macAddress.append(item.getText(0));
                    ++n2;
                }
                WidgetHelper.copyToClipboard((String)macAddress.toString());
            }
        };
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                SwitchForwardingDatabaseView.this.enableFilter(!SwitchForwardingDatabaseView.this.initShowFilter);
                SwitchForwardingDatabaseView.this.actionShowFilter.setChecked(SwitchForwardingDatabaseView.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.topology.commands.show_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SwitchForwardingDatabaseView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyRowToClipboard);
        manager.add((IAction)this.actionCopyMACToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.SwitchForwardingDatabaseView_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.topology", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List fdb = SwitchForwardingDatabaseView.this.session.getSwitchForwardingDatabase(SwitchForwardingDatabaseView.this.rootObject);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SwitchForwardingDatabaseView.this.viewer.setInput((Object)fdb.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.SwitchForwardingDatabaseView_JobError, SwitchForwardingDatabaseView.this.session.getObjectName(SwitchForwardingDatabaseView.this.rootObject));
            }
        }.start();
    }
}

