/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.packages.PackageDeploymentListener;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatus;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatusComparator;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatusLabelProvider;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PackageDeploymentMonitor
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.PackageDeploymentMonitor";
    public static final int COLUMN_NODE = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_ERROR = 2;
    private SortableTableViewer viewer;
    private long packageId;
    private Map<Long, DeploymentStatus> statusList = new HashMap<Long, DeploymentStatus>();
    private Action actionRedeploy;

    public void createPartControl(Composite parent) {
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.PackageDeploymentMonitor_ColumnNode;
        Messages.get();
        stringArray[1] = Messages.PackageDeploymentMonitor_ColumnStatus;
        Messages.get();
        stringArray[2] = Messages.PackageDeploymentMonitor_ColumnMessage;
        String[] names = stringArray;
        int[] widths = new int[]{200, 110, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DeploymentStatusLabelProvider());
        this.viewer.setComparator((ViewerComparator)new DeploymentStatusComparator());
        this.createActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void viewStatusUpdate(final long nodeId, final int status, final String message) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DeploymentStatus s = PackageDeploymentMonitor.this.statusList.get(nodeId);
                if (s == null) {
                    s = new DeploymentStatus(nodeId, status, message);
                    PackageDeploymentMonitor.this.statusList.put(nodeId, s);
                    PackageDeploymentMonitor.this.viewer.setInput((Object)PackageDeploymentMonitor.this.statusList.values().toArray());
                } else {
                    s.setStatus(status);
                    s.setMessage(message);
                    PackageDeploymentMonitor.this.viewer.update((Object)s, null);
                }
            }
        });
    }

    private void createActions() {
        Messages.get();
        this.actionRedeploy = new Action(Messages.PackageDeploymentMonitor_RestartFailedInstallation, SharedIcons.RESTART){

            public void run() {
                PackageDeploymentMonitor.this.redeployPackages();
            }
        };
    }

    private void redeployPackages() {
        final HashSet<Long> objects = new HashSet<Long>();
        Collection<DeploymentStatus> array = this.statusList.values();
        for (DeploymentStatus obj : array) {
            if (obj.getStatus() != 4) continue;
            objects.add(obj.getNodeObject().getObjectId());
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.PackageManager_DeployAgentPackage, null, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.deployPackage(PackageDeploymentMonitor.this.packageId, objects.toArray(new Long[objects.size()]), new PackageDeploymentListener(){

                    public void statusUpdate(long nodeId, int status, String message) {
                        PackageDeploymentMonitor.this.viewStatusUpdate(nodeId, status, message);
                    }

                    public void deploymentStarted() {
                    }

                    public void deploymentComplete() {
                        this.runInUIThread(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PackageDeploymentMonitor.this.getSite().getShell();
                                Messages.get();
                                Messages.get();
                                MessageDialogHelper.openInformation((Shell)shell, (String)Messages.PackageManager_Information, (String)Messages.PackageManager_PkgDepCompleted);
                            }
                        });
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.PackageManager_DepStartError;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRedeploy);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRedeploy);
    }

    public void setPackageId(long packageId) {
        this.packageId = packageId;
    }
}

