/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.CreatePolicyDialog;
import org.netxms.ui.eclipse.datacollection.views.PolicyEditorView;
import org.netxms.ui.eclipse.datacollection.views.helpers.PolicyComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.PolicyFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.PolicyLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PolicyListView
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.policy_list";
    public static final String JOB_FAMILY = "PolicyEditorJob";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_GUID = 2;
    private Display display;
    private NXCSession session;
    private long templateId;
    private String templateName;
    private HashMap<UUID, AgentPolicy> policies = null;
    private PolicyFilter filter;
    private FilterText filterText;
    private IDialogSettings settings;
    private SortableTableViewer policyList;
    private Action actionRefresh;
    private Action actionCreate;
    private Action actionDelete;
    private Action actionEdit;
    private Action actionRename;
    private Action actionCopy;
    private Action actionMove;
    private Action actionDuplicate;
    private Action actionShowFilter;
    private CompositeWithMessageBar viewerContainer;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.settings = Activator.getDefault().getDialogSettings();
        AbstractObject obj = this.session.findObjectById(Long.parseLong(site.getSecondaryId()));
        if (obj != null) {
            this.templateId = obj.getObjectId();
            this.templateName = obj.getObjectName();
            this.setPartName(String.format("Agent Policies - %s", this.templateName));
        }
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.viewerContainer = new CompositeWithMessageBar(parent, 0){

            protected Composite createContent(Composite parent) {
                Composite content = super.createContent(parent);
                content.setLayout((Layout)new FormLayout());
                return content;
            }
        };
        this.filterText = new FilterText(this.viewerContainer.getContent(), 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PolicyListView.this.onFilterModify();
            }
        });
        String[] names = new String[]{"Name", "Type", "GUID"};
        int[] widths = new int[]{250, 200, 100};
        this.policyList = new SortableTableViewer(this.viewerContainer.getContent(), names, widths, 0, 128, -1);
        this.policyList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.policyList.setLabelProvider((IBaseLabelProvider)new PolicyLabelProvider());
        this.policyList.setComparator((ViewerComparator)new PolicyComparator());
        this.filter = new PolicyFilter();
        this.policyList.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.policyList, (IDialogSettings)this.settings, (String)"PolicyEditorView");
        this.policyList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    PolicyListView.this.actionRename.setEnabled(selection.size() == 1);
                    PolicyListView.this.actionEdit.setEnabled(selection.size() == 1);
                    PolicyListView.this.actionDelete.setEnabled(selection.size() > 0);
                    PolicyListView.this.actionCopy.setEnabled(selection.size() > 0);
                    PolicyListView.this.actionMove.setEnabled(selection.size() > 0);
                    PolicyListView.this.actionDuplicate.setEnabled(selection.size() > 0);
                }
            }
        });
        this.policyList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PolicyListView.this.actionEdit.run();
            }
        });
        this.policyList.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)PolicyListView.this.policyList, (IDialogSettings)PolicyListView.this.settings, (String)"DataCollectionEditor");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.policyList.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(new Action(){

            public void run() {
                PolicyListView.this.enableFilter(false);
                PolicyListView.this.actionShowFilter.setChecked(false);
            }
        });
        if (this.actionShowFilter.isChecked()) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    private void refresh() {
        ConsoleJob job = new ConsoleJob("Save agent policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final HashMap serverPolicies = PolicyListView.this.session.getAgentPolicyList(PolicyListView.this.templateId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PolicyListView.this.policies = serverPolicies;
                        (this).PolicyListView.this.policyList.setInput((Object)(this).PolicyListView.this.policies.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Can not load policy list";
            }
        };
        job.start();
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PolicyListView.this.refresh();
            }
        };
        this.actionCreate = new Action("Create new", SharedIcons.ADD_OBJECT){

            public void run() {
                PolicyListView.this.createNewPolicy();
            }
        };
        this.actionRename = new Action("Rename policy"){

            public void run() {
                PolicyListView.this.renamePolicy();
            }
        };
        this.actionEdit = new Action("Edit", SharedIcons.EDIT){

            public void run() {
                PolicyListView.this.editPolicy();
            }
        };
        this.actionEdit.setImageDescriptor(Activator.getImageDescriptor("icons/edit.png"));
        this.actionEdit.setEnabled(false);
        this.actionCopy = new Action("Copy to another template(s)..."){

            public void run() {
                PolicyListView.this.copyItems(false);
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionMove = new Action("Move to another template(s)..."){

            public void run() {
                PolicyListView.this.copyItems(true);
            }
        };
        this.actionMove.setEnabled(false);
        this.actionDuplicate = new Action("Duplicate"){

            public void run() {
                PolicyListView.this.duplicateItems();
            }
        };
        this.actionDuplicate.setEnabled(false);
        this.actionDelete = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                PolicyListView.this.deletePolicy();
            }
        };
        this.actionDelete.setEnabled(false);
        Messages.get();
        this.actionShowFilter = new Action(Messages.DataCollectionEditor_ShowFilter, 2){

            public void run() {
                PolicyListView.this.enableFilter(PolicyListView.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("DataCollectionEditor.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    protected void renamePolicy() {
        IStructuredSelection selection = (IStructuredSelection)this.policyList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentPolicy policy = (AgentPolicy)selection.getFirstElement();
        CreatePolicyDialog dlg = new CreatePolicyDialog(this.getViewSite().getShell(), policy);
        if (dlg.open() != 0) {
            return;
        }
        final AgentPolicy newPolicy = dlg.getPolicy();
        new ConsoleJob("Rename policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PolicyListView.this.session.savePolicy(PolicyListView.this.templateId, newPolicy, false);
            }

            protected String getErrorMessage() {
                return "Cannot rename policy";
            }
        }.start();
    }

    protected void copyItems(final boolean doMove) {
        final ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), ObjectSelectionDialog.createTemplateSelectionFilter());
        if (dlg.open() != 0) {
            return;
        }
        if (dlg.getSelectedObjects(Template.class).length <= 0) {
            MessageDialogHelper.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Please select at least one destination template.");
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.policyList.getSelection();
        Iterator it = selection.iterator();
        final AgentPolicy[] policyList = new AgentPolicy[selection.size()];
        int i = 0;
        while (i < policyList.length && it.hasNext()) {
            policyList[i] = (AgentPolicy)it.next();
            ++i;
        }
        new ConsoleJob("Copy policy of template: " + this.templateName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                boolean sameObject = false;
                AbstractObject[] abstractObjectArray = dlg.getSelectedObjects(Template.class);
                int n = abstractObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractObject o = abstractObjectArray[n2];
                    if (o.getObjectId() != PolicyListView.this.templateId || !doMove) {
                        AgentPolicy[] agentPolicyArray = policyList;
                        int n3 = policyList.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            AgentPolicy p = agentPolicyArray[n4];
                            PolicyListView.this.session.savePolicy(o.getObjectId(), new AgentPolicy(p), true);
                            ++n4;
                        }
                    }
                    if (o.getObjectId() == PolicyListView.this.templateId) {
                        sameObject = true;
                    }
                    ++n2;
                }
                if (doMove) {
                    abstractObjectArray = policyList;
                    n = policyList.length;
                    n2 = 0;
                    while (n2 < n) {
                        AbstractObject p = abstractObjectArray[n2];
                        PolicyListView.this.session.deletePolicy(PolicyListView.this.templateId, p.getGuid());
                        ++n2;
                    }
                }
                if (doMove || sameObject) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            PolicyListView.this.showInformationMessage();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Error on policy item manipulcation for template: " + PolicyListView.this.templateName;
            }
        }.start();
    }

    protected void duplicateItems() {
        IStructuredSelection selection = (IStructuredSelection)this.policyList.getSelection();
        Iterator it = selection.iterator();
        final AgentPolicy[] policyList = new AgentPolicy[selection.size()];
        int i = 0;
        while (i < policyList.length && it.hasNext()) {
            policyList[i] = new AgentPolicy((AgentPolicy)it.next());
            ++i;
        }
        new ConsoleJob("Duplicate policy items for template: " + this.templateName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentPolicy[] agentPolicyArray = policyList;
                int n = policyList.length;
                int n2 = 0;
                while (n2 < n) {
                    AgentPolicy p = agentPolicyArray[n2];
                    PolicyListView.this.session.savePolicy(PolicyListView.this.templateId, p, true);
                    ++n2;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PolicyListView.this.showInformationMessage();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error duplicationg policies on template: " + PolicyListView.this.templateName;
            }
        }.start();
    }

    private void editPolicy() {
        IStructuredSelection selection = (IStructuredSelection)this.policyList.getSelection();
        AgentPolicy policy = (AgentPolicy)selection.getFirstElement();
        try {
            PolicyEditorView view = (PolicyEditorView)this.getSite().getPage().showView("org.netxms.ui.eclipse.datacollection.views.policy_editor", String.valueOf(policy.getGuid().toString()) + Long.toString(this.templateId), 1);
            if (view != null) {
                view.setPolicy(policy.getGuid(), this.templateId, new LocalChangeListener(){

                    public void onObjectChange() {
                        PolicyListView.this.showInformationMessage();
                    }
                });
            }
        }
        catch (PartInitException e) {
            MessageDialogHelper.openError((Shell)this.getSite().getWorkbenchWindow().getShell(), (String)"Error editing policy", (String)String.format("Error on policy edit: %s", e.getMessage()));
        }
    }

    protected void deletePolicy() {
        final IStructuredSelection selection = (IStructuredSelection)this.policyList.getSelection();
        if (selection.size() <= 0) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getSite().getShell(), (String)"Delete policy", (String)"Do you really want to delete selected policies?")) {
            return;
        }
        new ConsoleJob("DeletePolicy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Object policy : selection.toList()) {
                    PolicyListView.this.session.deletePolicy(PolicyListView.this.templateId, ((AgentPolicy)policy).getGuid());
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PolicyListView.this.showInformationMessage();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Can not delete policy";
            }
        }.start();
    }

    protected void createNewPolicy() {
        CreatePolicyDialog dlg = new CreatePolicyDialog(this.getViewSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        final AgentPolicy newPolicy = dlg.getPolicy();
        new ConsoleJob("Save policy", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final UUID newObjectGuid = PolicyListView.this.session.savePolicy(PolicyListView.this.templateId, newPolicy, false);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PolicyEditorView view = (PolicyEditorView)PolicyListView.this.getSite().getPage().showView("org.netxms.ui.eclipse.datacollection.views.policy_editor", String.valueOf(newObjectGuid.toString()) + Long.toString((this).PolicyListView.this.templateId), 1);
                            if (view != null) {
                                view.setPolicy(newObjectGuid, (this).PolicyListView.this.templateId, new LocalChangeListener(){

                                    public void onObjectChange() {
                                        PolicyListView.this.showInformationMessage();
                                    }
                                });
                            }
                        }
                        catch (PartInitException e) {
                            MessageDialogHelper.openError((Shell)PolicyListView.this.getSite().getWorkbenchWindow().getShell(), (String)"Error editing policy", (String)String.format("Error on policy edit: %s", e.getMessage()));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot update policy";
            }
        }.start();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)PolicyListView.this.actionEdit);
                mgr.add((IAction)PolicyListView.this.actionCreate);
                mgr.add((IAction)PolicyListView.this.actionDelete);
                mgr.add((IAction)PolicyListView.this.actionRename);
                mgr.add((IAction)PolicyListView.this.actionMove);
                mgr.add((IAction)PolicyListView.this.actionCopy);
                mgr.add((IAction)PolicyListView.this.actionDuplicate);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.policyList.getControl());
        this.policyList.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.policyList);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.policyList);
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void notificationHandler(final SessionNotification n) {
        switch (n.getCode()) {
            case 1039: {
                if (n.getSubCode() != this.templateId) {
                    return;
                }
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PolicyListView.this.policyList.getControl().isDisposed()) {
                            return;
                        }
                        AgentPolicy policy = PolicyListView.this.policies.get(((AgentPolicy)n.getObject()).getGuid());
                        if (policy != null) {
                            policy.update((AgentPolicy)n.getObject());
                            PolicyListView.this.policyList.update((Object)policy, null);
                        } else {
                            PolicyListView.this.policies.put(((AgentPolicy)n.getObject()).getGuid(), (AgentPolicy)n.getObject());
                            PolicyListView.this.policyList.setInput((Object)PolicyListView.this.policies.values().toArray());
                        }
                    }
                });
                break;
            }
            case 1040: {
                if (n.getSubCode() != this.templateId) {
                    return;
                }
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PolicyListView.this.policyList.getControl().isDisposed()) {
                            return;
                        }
                        PolicyListView.this.policies.remove((UUID)n.getObject());
                        PolicyListView.this.policyList.setInput((Object)PolicyListView.this.policies.values().toArray());
                    }
                });
            }
        }
    }

    public void dispose() {
        ConsoleJob job = new ConsoleJob("Update policy on editor close", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PolicyListView.this.session.onPolicyEditorClose(PolicyListView.this.templateId);
            }

            protected String getErrorMessage() {
                return "Cannot update policy on editor close";
            }
        };
        job.setUser(false);
        job.start();
        super.dispose();
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.policyList.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.viewerContainer.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        this.settings.put("DataCollectionEditor.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.policyList.refresh(false);
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = this.settings.get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }

    public void setFocus() {
    }

    public void showInformationMessage() {
        if (!this.viewerContainer.isDisposed()) {
            this.viewerContainer.showMessage(0, "Changes in policies will be deployed to nodes the moment when the tab is closed");
        }
    }
}

