/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.ThresholdLabelProvider;

public class LastValuesLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private Image[] stateImages = new Image[3];
    private boolean useMultipliers = true;
    private boolean showErrors = true;
    private ThresholdLabelProvider thresholdLabelProvider;

    public LastValuesLabelProvider() {
        this.stateImages[0] = Activator.getImageDescriptor("icons/active.gif").createImage();
        this.stateImages[1] = Activator.getImageDescriptor("icons/disabled.gif").createImage();
        this.stateImages[2] = Activator.getImageDescriptor("icons/unsupported.gif").createImage();
        this.thresholdLabelProvider = new ThresholdLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.stateImages[((DciValue)element).getStatus()];
            }
            case 4: {
                Threshold threshold = ((DciValue)element).getActiveThreshold();
                return threshold != null ? this.thresholdLabelProvider.getColumnImage(threshold, 1) : StatusDisplayInfo.getStatusImage((Severity)Severity.NORMAL);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Long.toString(((DciValue)element).getId());
            }
            case 1: {
                return ((DciValue)element).getDescription();
            }
            case 2: {
                if (this.showErrors && ((DciValue)element).getErrorCount() > 0) {
                    Messages.get();
                    return Messages.LastValuesLabelProvider_Error;
                }
                if (((DciValue)element).getDcObjectType() == 2) {
                    Messages.get();
                    return Messages.LastValuesLabelProvider_Table;
                }
                int selection = ((DciValue)element).getMultipliersSelection();
                if (selection == 0) {
                    return this.useMultipliers ? ((DciValue)element).format("%*s") : ((DciValue)element).getValue();
                }
                if (selection == 1) {
                    return ((DciValue)element).format("%*s");
                }
                return ((DciValue)element).getValue();
            }
            case 3: {
                if (((DciValue)element).getTimestamp().getTime() <= 1000L) {
                    return null;
                }
                return RegionalSettings.getDateTimeFormat().format(((DciValue)element).getTimestamp());
            }
            case 4: {
                return this.formatThreshold((DciValue)element);
            }
        }
        return null;
    }

    private String formatThreshold(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        if (threshold == null) {
            Messages.get();
            return Messages.LastValuesLabelProvider_OK;
        }
        if (value.getDcObjectType() == 2) {
            return threshold.getValue();
        }
        return this.thresholdLabelProvider.getColumnText(threshold, 0);
    }

    public void dispose() {
        int i = 0;
        while (i < this.stateImages.length) {
            this.stateImages[i].dispose();
            ++i;
        }
        this.thresholdLabelProvider.dispose();
        super.dispose();
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (((DciValue)element).getStatus() == 1) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNMANAGED);
        }
        if (this.showErrors && ((DciValue)element).getErrorCount() > 0) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

