/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.dialogs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.Severity;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objects.ObjectContext;

public class ToolExecutionStatusDialog
extends Dialog {
    private Map<Long, Task> tasks = new HashMap<Long, Task>();
    private TableViewer viewer;

    public ToolExecutionStatusDialog(Shell parentShell, Set<ObjectContext> nodes) {
        super(parentShell);
        for (ObjectContext c : nodes) {
            Task task = new Task(c);
            this.tasks.put(task.node.getObjectId(), task);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Tool Execution Status");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 68352);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 600;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TaskLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((Task)e1).node.getObjectName().compareToIgnoreCase(((Task)e2).node.getObjectName());
            }
        });
        TableColumn column = new TableColumn(this.viewer.getTable(), 0);
        column.setText("Node");
        column.setWidth(500);
        column = new TableColumn(this.viewer.getTable(), 0);
        column.setText("Status");
        column.setWidth(200);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setInput((Object)this.tasks.values().toArray());
        return dialogArea;
    }

    public void updateExecutionStatus(long nodeId, String failureReason) {
        if (this.viewer.getControl().isDisposed()) {
            return;
        }
        final Task task = this.tasks.get(nodeId);
        if (task != null) {
            task.status = failureReason != null ? 2 : 1;
            task.failureReason = failureReason;
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ToolExecutionStatusDialog.this.viewer.update((Object)task, null);
                }
            });
        }
    }

    private static class Task {
        static final int RUNNING = 0;
        static final int COMPLETED = 1;
        static final int FAILED = 2;
        AbstractNode node;
        int status;
        String failureReason;

        Task(ObjectContext context) {
            this.node = context.object;
            this.status = 0;
            this.failureReason = null;
        }
    }

    private static class TaskLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider workbenchLabelProvider = WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();

        private TaskLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.workbenchLabelProvider.getImage((Object)((Task)element).node);
                }
                case 1: {
                    switch (((Task)element).status) {
                        case 0: {
                            return SharedIcons.IMG_EXECUTE;
                        }
                        case 1: {
                            return StatusDisplayInfo.getStatusImage((Severity)Severity.NORMAL);
                        }
                        case 2: {
                            return StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL);
                        }
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Task)element).node.getObjectName();
                }
                case 1: {
                    switch (((Task)element).status) {
                        case 0: {
                            return "In progress";
                        }
                        case 1: {
                            return "OK";
                        }
                        case 2: {
                            return ((Task)element).failureReason;
                        }
                    }
                }
            }
            return null;
        }

        public void dispose() {
            this.workbenchLabelProvider.dispose();
            super.dispose();
        }
    }
}

