/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmHandle;
import org.netxms.client.events.BulkAlarmStateChangeData;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.AlarmNotifier;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AcknowledgeCustomTimeDialog;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AlarmStateChangeFailureDialog;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmAcknowledgeTimeFunctions;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmComparator;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmListFilter;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmListLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmToolTip;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmTreeContentProvider;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.views.TabbedObjectView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.FilteringMenuManager;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.tools.TransformationSelectionProvider;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;
import org.netxms.ui.eclipse.widgets.helpers.SearchQueryAttribute;
import org.netxms.ui.eclipse.widgets.helpers.SearchQueryAttributeValueProvider;
import org.netxms.ui.eclipse.widgets.helpers.SearchQueryContentProposalProvider;

public class AlarmList
extends CompositeWithMessageBar {
    public static final int COLUMN_SEVERITY = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_ZONE = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_COUNT = 5;
    public static final int COLUMN_COMMENTS = 6;
    public static final int COLUMN_HELPDESK_REF = 7;
    public static final int COLUMN_ACK_BY = 8;
    public static final int COLUMN_CREATED = 9;
    public static final int COLUMN_LASTCHANGE = 10;
    private final IViewPart viewPart;
    private NXCSession session = null;
    private SessionListener clientListener = null;
    private RefreshTimer refreshTimer;
    private SortableTreeViewer alarmViewer;
    private AlarmListLabelProvider labelProvider;
    private AlarmListFilter alarmFilter;
    private TransformationSelectionProvider alarmSelectionProvider;
    private FilterText filterText;
    private Point toolTipLocation;
    private Alarm toolTipObject;
    private Map<Long, Alarm> alarmList = new HashMap<Long, Alarm>();
    private List<Alarm> newAlarmList = new ArrayList<Alarm>();
    private Set<Long> updateList = new HashSet<Long>();
    private Map<Long, AlarmHandle> displayList = new HashMap<Long, AlarmHandle>();
    private VisibilityValidator visibilityValidator;
    private boolean needInitialRefresh = false;
    private boolean filterRunning = false;
    private boolean filterRunPending = false;
    private Action actionCopy;
    private Action actionCopyMessage;
    private Action actionComments;
    private Action actionAcknowledge;
    private Action actionResolve;
    private Action actionStickyAcknowledge;
    private Action actionTerminate;
    private Action actionShowAlarmDetails;
    private Action actionShowObjectDetails;
    private Action actionCreateIssue;
    private Action actionShowIssue;
    private Action actionUnlinkIssue;
    private Action actionExportToCsv;
    private Action actionShowFilter;
    private MenuManager timeAcknowledgeMenu;
    private List<Action> timeAcknowledge;
    private Action timeAcknowledgeOther;
    private Action actionShowColor;
    private boolean initShowfilter;
    private boolean isLocalNotificationsEnabled = false;
    private final SearchQueryAttribute[] attributeProposals = new SearchQueryAttribute[]{new SearchQueryAttribute("AcknowledgedBy:"), new SearchQueryAttribute("Event:", (SearchQueryAttributeValueProvider)new EventAttributeValueProvider()), new SearchQueryAttribute("HasComments:", new String[]{"yes", "no"}), new SearchQueryAttribute("NOT"), new SearchQueryAttribute("RepeatCount:"), new SearchQueryAttribute("ResolvedBy:"), new SearchQueryAttribute("Severity:", new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL"}), new SearchQueryAttribute("Source:", (SearchQueryAttributeValueProvider)new SourceAttributeValueProvider()), new SearchQueryAttribute("State:", new String[]{"Outstanding", "Acknowledged", "Resolved"}), new SearchQueryAttribute("Zone:", (SearchQueryAttributeValueProvider)new ZoneAttributeValueProvider())};

    public AlarmList(IViewPart viewPart, Composite parent, int style, final String configPrefix, VisibilityValidator visibilityValidator) {
        super(parent, style);
        this.session = ConsoleSharedData.getSession();
        this.viewPart = viewPart;
        this.visibilityValidator = visibilityValidator;
        this.getContent().setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.getContent(), 0, null, true, true, (IContentProposalProvider)new SearchQueryContentProposalProvider(this.attributeProposals));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AlarmList.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                AlarmList.this.enableFilter(false);
                AlarmList.this.actionShowFilter.setChecked(false);
            }
        });
        String[] stringArray = new String[11];
        Messages.get();
        stringArray[0] = Messages.AlarmList_ColumnSeverity;
        Messages.get();
        stringArray[1] = Messages.AlarmList_ColumnState;
        Messages.get();
        stringArray[2] = Messages.AlarmList_ColumnSource;
        stringArray[3] = "Zone";
        Messages.get();
        stringArray[4] = Messages.AlarmList_ColumnMessage;
        Messages.get();
        stringArray[5] = Messages.AlarmList_ColumnCount;
        Messages.get();
        stringArray[6] = Messages.AlarmList_Comments;
        Messages.get();
        stringArray[7] = Messages.AlarmList_HelpdeskId;
        Messages.get();
        stringArray[8] = Messages.AlarmList_AckBy;
        Messages.get();
        stringArray[9] = Messages.AlarmList_ColumnCreated;
        Messages.get();
        stringArray[10] = Messages.AlarmList_ColumnLastChange;
        String[] names = stringArray;
        int[] widths = new int[]{100, 100, 150, 130, 300, 70, 70, 120, 100, 100, 100};
        this.alarmViewer = new SortableTreeViewer(this.getContent(), names, widths, 0, 1024, -1);
        if (!this.session.isZoningEnabled()) {
            this.alarmViewer.removeColumnById(3);
        }
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
        this.labelProvider = new AlarmListLabelProvider((TreeViewer)this.alarmViewer);
        this.labelProvider.setShowColor(Activator.getDefault().getPreferenceStore().getBoolean("SHOW_ALARM_STATUS_COLORS"));
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.alarmViewer.setContentProvider((IContentProvider)new AlarmTreeContentProvider());
        this.alarmViewer.setComparator((ViewerComparator)new AlarmComparator());
        this.alarmFilter = new AlarmListFilter();
        this.alarmViewer.addFilter((ViewerFilter)this.alarmFilter);
        this.alarmViewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)AlarmList.this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
            }
        });
        this.alarmViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlarmList.this.actionShowAlarmDetails.run();
            }
        });
        this.alarmViewer.setInput(this.displayList);
        final Runnable toolTipTimer = new Runnable(){

            @Override
            public void run() {
                AlarmToolTip t = new AlarmToolTip((Control)AlarmList.this.alarmViewer.getTree(), AlarmList.this.toolTipObject);
                t.show(AlarmList.this.toolTipLocation);
            }
        };
        this.alarmViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_ALARM_TOOLTIPS")) {
                    return;
                }
                Point p = new Point(e.x, e.y);
                TreeItem item = AlarmList.this.alarmViewer.getTree().getItem(p);
                if (item == null) {
                    return;
                }
                AlarmList.this.toolTipObject = (Alarm)item.getData();
                p.x -= 10;
                p.y -= 10;
                AlarmList.this.toolTipLocation = p;
                AlarmList.this.getDisplay().timerExec(300, toolTipTimer);
            }

            public void mouseExit(MouseEvent e) {
                AlarmList.this.getDisplay().timerExec(-1, toolTipTimer);
            }
        });
        this.initShowfilter = Activator.getDefault().getPreferenceStore().getBoolean("INIT_SHOW_FILTER");
        this.createActions();
        this.createPopupMenu();
        if (visibilityValidator == null || visibilityValidator.isVisible()) {
            this.refresh();
        } else {
            this.needInitialRefresh = true;
        }
        this.refreshTimer = new RefreshTimer(Math.max(this.session.getMinViewRefreshInterval(), 500), this.alarmViewer.getControl(), new Runnable(){

            @Override
            public void run() {
                AlarmList.this.startFilterAndLimit();
            }
        });
        this.refreshTimer.setMinimalDelay(100L);
        this.clientListener = new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1004: {
                        Object object = AlarmList.this.newAlarmList;
                        synchronized (object) {
                            AlarmList.this.newAlarmList.add((Alarm)n.getObject());
                        }
                    }
                    case 1005: {
                        Alarm oldAlarm;
                        Object object = AlarmList.this.alarmList;
                        synchronized (object) {
                            oldAlarm = AlarmList.this.alarmList.put(((Alarm)n.getObject()).getId(), (Alarm)n.getObject());
                            AlarmList.this.updateList.add(((Alarm)n.getObject()).getId());
                        }
                        if (!AlarmList.this.alarmFilter.filter((Alarm)n.getObject()) && (oldAlarm == null || !AlarmList.this.alarmFilter.filter(oldAlarm))) break;
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                    case 1003: 
                    case 1011: {
                        Alarm oldAlarm;
                        Map<Long, Alarm> map = AlarmList.this.alarmList;
                        synchronized (map) {
                            oldAlarm = AlarmList.this.alarmList.remove(((Alarm)n.getObject()).getId());
                        }
                        if (oldAlarm == null || !AlarmList.this.alarmFilter.filter(oldAlarm)) break;
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                    case 1033: {
                        boolean changed = false;
                        Map<Long, Alarm> map = AlarmList.this.alarmList;
                        synchronized (map) {
                            BulkAlarmStateChangeData d = (BulkAlarmStateChangeData)n.getObject();
                            for (Long id : d.getAlarms()) {
                                Alarm a = AlarmList.this.alarmList.get(id);
                                if (a == null) continue;
                                a.setResolved(d.getUserId(), d.getChangeTime());
                                AlarmList.this.updateList.add(a.getId());
                                changed = true;
                            }
                        }
                        if (!changed) break;
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                    case 1032: {
                        boolean changed = false;
                        Map<Long, Alarm> map = AlarmList.this.alarmList;
                        synchronized (map) {
                            for (Long id : ((BulkAlarmStateChangeData)n.getObject()).getAlarms()) {
                                if (AlarmList.this.alarmList.remove(id) == null) continue;
                                changed = true;
                            }
                        }
                        if (!changed) break;
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                }
            }
        };
        this.session.addListener(this.clientListener);
        final Runnable blinkTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AlarmList.this.isDisposed()) {
                    return;
                }
                int count = 0;
                Map<Long, Alarm> map = AlarmList.this.alarmList;
                synchronized (map) {
                    for (Alarm a : AlarmList.this.alarmList.values()) {
                        if (a.getState() != 0) continue;
                        ++count;
                    }
                }
                if (count > 0) {
                    ((AlarmListLabelProvider)AlarmList.this.alarmViewer.getLabelProvider()).toggleBlinkState();
                    AlarmList.this.alarmViewer.refresh();
                }
                AlarmList.this.getDisplay().timerExec(500, (Runnable)this);
            }
        };
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
            this.getDisplay().timerExec(500, blinkTimer);
        }
        final IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("BLINK_OUTSTANDING_ALARMS")) {
                    if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
                        AlarmList.this.getDisplay().timerExec(500, blinkTimer);
                    } else {
                        AlarmList.this.getDisplay().timerExec(-1, blinkTimer);
                    }
                } else if (event.getProperty().equals("SHOW_ALARM_STATUS_COLORS")) {
                    boolean showColors = ps.getBoolean("SHOW_ALARM_STATUS_COLORS");
                    if (AlarmList.this.labelProvider.isShowColor() != showColors) {
                        AlarmList.this.labelProvider.setShowColor(showColors);
                        AlarmList.this.actionShowColor.setChecked(showColors);
                        AlarmList.this.alarmViewer.refresh();
                    }
                }
            }
        };
        ps.addPropertyChangeListener(propertyChangeListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ps.removePropertyChangeListener(propertyChangeListener);
                if (AlarmList.this.session != null && AlarmList.this.clientListener != null) {
                    AlarmList.this.session.removeListener(AlarmList.this.clientListener);
                }
                ps.setDefault("INIT_SHOW_FILTER", AlarmList.this.initShowfilter);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.alarmViewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        if (this.initShowfilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.alarmSelectionProvider = new TransformationSelectionProvider((ISelectionProvider)this.alarmViewer){

            protected ISelection transformSelection(ISelection selection) {
                if (!(selection instanceof IStructuredSelection)) {
                    return selection;
                }
                ArrayList<Alarm> alarms = new ArrayList<Alarm>(((IStructuredSelection)selection).size());
                for (Object o : ((IStructuredSelection)selection).toList()) {
                    alarms.add(((AlarmHandle)o).alarm);
                }
                return new StructuredSelection(alarms);
            }
        };
    }

    public ISelectionProvider getSelectionProvider() {
        return this.alarmSelectionProvider;
    }

    private void createActions() {
        Messages.get();
        this.actionCopy = new Action(Messages.AlarmList_CopyToClipboard){

            public void run() {
                TreeItem[] selection = AlarmList.this.alarmViewer.getTree().getSelection();
                if (selection.length > 0) {
                    String newLine = WidgetHelper.getNewLineCharacters();
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append('[');
                        sb.append(selection[i].getText(WidgetHelper.getColumnIndexById((Tree)AlarmList.this.alarmViewer.getTree(), (int)0)));
                        sb.append("]\t");
                        sb.append(selection[i].getText(WidgetHelper.getColumnIndexById((Tree)AlarmList.this.alarmViewer.getTree(), (int)2)));
                        sb.append('\t');
                        sb.append(selection[i].getText(WidgetHelper.getColumnIndexById((Tree)AlarmList.this.alarmViewer.getTree(), (int)4)));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopy.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Copy");
        Messages.get();
        this.actionCopyMessage = new Action(Messages.AlarmList_CopyMsgToClipboard){

            public void run() {
                TreeItem[] selection = AlarmList.this.alarmViewer.getTree().getSelection();
                if (selection.length > 0) {
                    String newLine = WidgetHelper.getNewLineCharacters();
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append(selection[i].getText(WidgetHelper.getColumnIndexById((Tree)AlarmList.this.alarmViewer.getTree(), (int)4)));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopyMessage.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.CopyMessage");
        Messages.get();
        this.actionComments = new Action(Messages.AlarmList_Comments, Activator.getImageDescriptor("icons/comments.png")){

            public void run() {
                AlarmList.this.openAlarmDetailsView("org.netxms.ui.eclipse.alarmviewer.views.AlarmComments");
            }
        };
        this.actionComments.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Comments");
        Messages.get();
        this.actionShowAlarmDetails = new Action(Messages.AlarmList_ActionAlarmDetails){

            public void run() {
                AlarmList.this.openAlarmDetailsView("org.netxms.ui.eclipse.alarmviewer.views.AlarmDetails");
            }
        };
        this.actionShowAlarmDetails.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.AlarmDetails");
        Messages.get();
        this.actionAcknowledge = new Action(Messages.AlarmList_Acknowledge, Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(false, 0);
            }
        };
        this.actionAcknowledge.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Acknowledge");
        Messages.get();
        this.actionStickyAcknowledge = new Action(Messages.AlarmList_StickyAck, Activator.getImageDescriptor("icons/acknowledged_sticky.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(true, 0);
            }
        };
        this.actionStickyAcknowledge.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.StickyAcknowledge");
        Messages.get();
        this.actionResolve = new Action(Messages.AlarmList_Resolve, Activator.getImageDescriptor("icons/resolved.png")){

            public void run() {
                AlarmList.this.resolveAlarms();
            }
        };
        this.actionResolve.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Resolve");
        Messages.get();
        this.actionTerminate = new Action(Messages.AlarmList_Terminate, Activator.getImageDescriptor("icons/terminated.png")){

            public void run() {
                AlarmList.this.terminateAlarms();
            }
        };
        this.actionTerminate.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Terminate");
        Messages.get();
        this.actionCreateIssue = new Action(Messages.AlarmList_CreateTicket, Activator.getImageDescriptor("icons/helpdesk_ticket.png")){

            public void run() {
                AlarmList.this.createIssue();
            }
        };
        Messages.get();
        this.actionShowIssue = new Action(Messages.AlarmList_ShowTicketInBrowser, SharedIcons.BROWSER){

            public void run() {
                AlarmList.this.showIssue();
            }
        };
        Messages.get();
        this.actionUnlinkIssue = new Action(Messages.AlarmList_UnlinkTicket){

            public void run() {
                AlarmList.this.unlinkIssue();
            }
        };
        Messages.get();
        this.actionShowObjectDetails = new Action(Messages.AlarmList_ActionObjectDetails){

            public void run() {
                AlarmList.this.showObjectDetails();
            }
        };
        this.actionShowObjectDetails.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.ShowObjectDetails");
        this.actionExportToCsv = new ExportToCsvAction(this.viewPart, (ColumnViewer)this.alarmViewer, true);
        this.timeAcknowledgeOther = new Action("Other...", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time;
                AcknowledgeCustomTimeDialog dlg = new AcknowledgeCustomTimeDialog(AlarmList.this.viewPart.getSite().getShell());
                if (dlg.open() == 0 && (time = dlg.getTime()) > 0) {
                    AlarmList.this.acknowledgeAlarms(true, time);
                }
            }
        };
        this.timeAcknowledgeOther.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledgeOther");
        Messages.get();
        this.actionShowColor = new Action(Messages.AlarmList_ShowStatusColors, 2){

            public void run() {
                AlarmList.this.labelProvider.setShowColor(AlarmList.this.actionShowColor.isChecked());
                AlarmList.this.alarmViewer.refresh();
                Activator.getDefault().getPreferenceStore().setValue("SHOW_ALARM_STATUS_COLORS", AlarmList.this.actionShowColor.isChecked());
            }
        };
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowFilter = new Action("Show filter"){

            public void run() {
                AlarmList.this.enableFilter(AlarmList.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.initShowfilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.alarmviewer.commands.show_filter_alarm_list");
    }

    private void initializeTimeAcknowledge() {
        int menuSize;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            menuSize = settings.getInt("AlarmList.ackMenuSize");
        }
        catch (NumberFormatException e) {
            settings.put("AlarmList.ackMenuSize", 4);
            this.timeAcknowledge = new ArrayList<Action>(4);
            this.createDefaultIntervals();
            settings.put("AlarmList.ackMenuEntry0", 3600);
            settings.put("AlarmList.ackMenuEntry1", 14400);
            settings.put("AlarmList.ackMenuEntry2", 86400);
            settings.put("AlarmList.ackMenuEntry3", 172800);
            return;
        }
        this.timeAcknowledge = new ArrayList<Action>(menuSize);
        int i = 0;
        while (i < menuSize) {
            final int time = settings.getInt("AlarmList.ackMenuEntry" + Integer.toString(i));
            if (time != 0) {
                String title = AlarmAcknowledgeTimeFunctions.timeToString(time);
                Action action = new Action(title, Activator.getImageDescriptor("icons/acknowledged.png")){

                    public void run() {
                        AlarmList.this.acknowledgeAlarms(true, time);
                    }
                };
                action.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge" + Integer.toString(i) + "ID");
                this.timeAcknowledge.add(action);
            }
            ++i;
        }
    }

    private void createDefaultIntervals() {
        Action act = new Action("1 hour(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 3600;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge0ID");
        this.timeAcknowledge.add(act);
        act = new Action("4 hour(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 14400;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge1ID");
        this.timeAcknowledge.add(act);
        act = new Action("1 day(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 86400;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge2ID");
        this.timeAcknowledge.add(act);
        act = new Action("2 days(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 172800;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge3ID");
        this.timeAcknowledge.add(act);
    }

    private void createPopupMenu() {
        FilteringMenuManager menuMgr = new FilteringMenuManager("org.netxms.ui.eclipse.alarmviewer");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AlarmList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.alarmSelectionProvider);
            this.viewPart.getSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)this.alarmViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        int states = this.getSelectionType(selection.toArray());
        if (states == 2) {
            manager.add((IAction)this.actionAcknowledge);
            manager.add((IAction)this.actionStickyAcknowledge);
            if (this.session.isTimedAlarmAckEnabled()) {
                this.initializeTimeAcknowledge();
                Messages.get();
                this.timeAcknowledgeMenu = new MenuManager(Messages.AlarmList_StickyAckMenutTitle, "timeAcknowledge");
                for (Action act : this.timeAcknowledge) {
                    this.timeAcknowledgeMenu.add((IAction)act);
                }
                this.timeAcknowledgeMenu.add((IContributionItem)new Separator());
                this.timeAcknowledgeMenu.add((IAction)this.timeAcknowledgeOther);
                manager.add((IContributionItem)this.timeAcknowledgeMenu);
            }
        }
        if (states < 4) {
            manager.add((IAction)this.actionResolve);
        }
        if (states == 4 || !this.session.isStrictAlarmStatusFlow()) {
            manager.add((IAction)this.actionTerminate);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            manager.add((IContributionItem)new GroupMarker("objecttools"));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowObjectDetails);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyMessage);
        manager.add((IAction)this.actionExportToCsv);
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowAlarmDetails);
            manager.add((IAction)this.actionComments);
            if (this.session.isHelpdeskLinkActive()) {
                manager.add((IContributionItem)new Separator());
                if (((Alarm)selection.getFirstElement()).getHelpdeskState() == 0) {
                    manager.add((IAction)this.actionCreateIssue);
                } else {
                    manager.add((IAction)this.actionShowIssue);
                    if ((this.session.getUserSystemRights() & 0x10000000L) != 0L) {
                        manager.add((IAction)this.actionUnlinkIssue);
                    }
                }
            }
        }
    }

    private int getSelectionType(Object[] array) {
        int type = 0;
        int i = 0;
        while (i < array.length) {
            type |= ((Alarm)array[i]).getState() + 2;
            ++i;
        }
        return type;
    }

    public void setRootObject(long objectId) {
        this.alarmFilter.setRootObject(objectId);
        this.filterRunPending = true;
        this.doPendingUpdates();
    }

    public void setRootObjects(List<Long> selectedObjects) {
        this.alarmFilter.setRootObjects(selectedObjects);
        this.filterRunPending = true;
        this.doPendingUpdates();
    }

    public void doPendingUpdates() {
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        if (this.needInitialRefresh) {
            this.needInitialRefresh = false;
            this.refresh();
        } else if (this.filterRunPending) {
            this.startFilterAndLimit();
        }
    }

    private void startFilterAndLimit() {
        if (this.filterRunning || this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            this.filterRunPending = true;
            return;
        }
        this.filterRunning = true;
        this.filterRunPending = false;
        ConsoleJob job = new ConsoleJob("Filter alarms", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Map<Long, Alarm> map = AlarmList.this.alarmList;
                synchronized (map) {
                    AlarmList.this.filterAndLimit();
                }
            }

            protected String getErrorMessage() {
                return "Cannot filter alartm list";
            }
        };
        job.setUser(false);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterAndLimit() {
        HashMap<Long, Alarm> filteredAlarms;
        final HashMap<Long, Alarm> selectedAlarms = new HashMap<Long, Alarm>();
        for (Alarm alarm : this.alarmList.values()) {
            if (!this.alarmFilter.filter(alarm)) continue;
            selectedAlarms.put(alarm.getId(), alarm);
        }
        if (this.session.getAlarmListDisplayLimit() > 0 && selectedAlarms.size() > this.session.getAlarmListDisplayLimit()) {
            ArrayList l = new ArrayList(selectedAlarms.values());
            Collections.sort(l, new Comparator<Alarm>(){

                @Override
                public int compare(Alarm alarm1, Alarm alarm2) {
                    return -alarm1.getLastChangeTime().compareTo(alarm2.getLastChangeTime());
                }
            });
            filteredAlarms = new HashMap(this.session.getAlarmListDisplayLimit());
            for (Alarm a : l.subList(0, this.session.getAlarmListDisplayLimit())) {
                filteredAlarms.put(a.getId(), a);
            }
        } else {
            filteredAlarms = selectedAlarms;
        }
        final ArrayList<Long> updatedAlarms = new ArrayList<Long>(this.updateList.size());
        updatedAlarms.addAll(this.updateList);
        this.updateList.clear();
        this.alarmViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                AlarmHandle h;
                if (AlarmList.this.alarmViewer.getControl().isDisposed()) {
                    return;
                }
                int initialSize = AlarmList.this.displayList.size();
                AlarmList.this.displayList.entrySet().removeIf(e -> !filteredAlarms.containsKey(e.getKey()));
                boolean structuralChanges = AlarmList.this.displayList.size() != initialSize;
                for (Alarm a : filteredAlarms.values()) {
                    h = AlarmList.this.displayList.get(a.getId());
                    if (h != null) {
                        h.alarm = a;
                        continue;
                    }
                    AlarmList.this.displayList.put(a.getId(), new AlarmHandle(a));
                    structuralChanges = true;
                }
                if (structuralChanges) {
                    AlarmList.this.alarmViewer.getControl().setRedraw(false);
                    TreeItem topItem = AlarmList.this.alarmViewer.getTree().getTopItem();
                    AlarmList.this.alarmViewer.refresh();
                    if (topItem != null && !topItem.isDisposed()) {
                        AlarmList.this.alarmViewer.getTree().setTopItem(topItem);
                    }
                    AlarmList.this.alarmViewer.getControl().setRedraw(true);
                } else {
                    ArrayList<AlarmHandle> updatedElements = new ArrayList<AlarmHandle>(updatedAlarms.size());
                    int i = 0;
                    while (i < updatedAlarms.size()) {
                        h = AlarmList.this.displayList.get(updatedAlarms.get(i));
                        if (h != null) {
                            updatedElements.add(h);
                        }
                        ++i;
                    }
                    AlarmList.this.alarmViewer.update(updatedElements.toArray(), new String[]{"message"});
                }
                if (AlarmList.this.session.getAlarmListDisplayLimit() > 0 && selectedAlarms.size() >= AlarmList.this.session.getAlarmListDisplayLimit()) {
                    Messages.get();
                    AlarmList.this.showMessage(0, String.format(Messages.AlarmList_CountLimitWarning, filteredAlarms.size()));
                } else {
                    AlarmList.this.hideMessage();
                }
                AlarmList.this.filterRunning = false;
                if (AlarmList.this.filterRunPending) {
                    AlarmList.this.filterRunPending = false;
                    AlarmList.this.refreshTimer.execute();
                }
            }
        });
        List<Alarm> list = this.newAlarmList;
        synchronized (list) {
            if (!AlarmNotifier.isGlobalSoundEnabled() && this.viewPart.getSite().getPage().isPartVisible((IWorkbenchPart)this.viewPart) && this.isLocalNotificationsEnabled) {
                for (Alarm a : this.newAlarmList) {
                    if (!filteredAlarms.containsKey(a.getId())) continue;
                    AlarmNotifier.playSounOnAlarm(a);
                }
            }
            this.newAlarmList.clear();
        }
    }

    public void refresh() {
        if (this.visibilityValidator != null && !this.visibilityValidator.isVisible()) {
            return;
        }
        this.filterRunning = true;
        this.filterRunPending = false;
        Messages.get();
        new ConsoleJob(Messages.AlarmList_SyncJobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                HashMap alarms = AlarmList.this.session.getAlarms();
                Map<Long, Alarm> map = AlarmList.this.alarmList;
                synchronized (map) {
                    AlarmList.this.alarmList.clear();
                    AlarmList.this.alarmList.putAll(alarms);
                    AlarmList.this.filterAndLimit();
                }
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmList.this.showMessage(2, String.valueOf(this.getErrorMessage()) + ": " + e.getMessage());
                    }
                });
                return Status.OK_STATUS;
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_SyncJobError;
            }
        }.start();
    }

    private void openAlarmDetailsView(String viewId) {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        String secondaryId = Long.toString(((Alarm)selection.getFirstElement()).getId());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView(viewId, secondaryId, 1);
        }
        catch (PartInitException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmList_Error, (String)(String.valueOf(Messages.AlarmList_ErrorText) + e.getLocalizedMessage()));
        }
    }

    public void setStateFilter(int filter) {
        this.alarmFilter.setStateFilter(filter);
    }

    public void setSeverityFilter(int filter) {
        this.alarmFilter.setSeverityFilter(filter);
    }

    private void acknowledgeAlarms(final boolean sticky, final int time) {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object[] alarms = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.AcknowledgeAlarm_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.AcknowledgeAlarm_TaskName, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.acknowledgeAlarm(((Alarm)o).getId(), sticky, time);
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AcknowledgeAlarm_ErrorMessage;
            }
        }.start();
    }

    private void resolveAlarms() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<Long> alarmIds = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            alarmIds.add(((Alarm)o).getId());
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmList_Resolving, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map resolveFails = AlarmList.this.session.bulkResolveAlarms(alarmIds);
                if (!resolveFails.isEmpty()) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AlarmStateChangeFailureDialog dlg = new AlarmStateChangeFailureDialog((this).AlarmList.this.viewPart.getSite().getShell(), resolveFails);
                            if (dlg.open() == 0) {
                                return;
                            }
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_CannotResoveAlarm;
            }
        }.start();
    }

    private void terminateAlarms() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        final ArrayList<Long> alarmIds = new ArrayList<Long>(selection.size());
        for (Object o : selection.toList()) {
            alarmIds.add(((Alarm)o).getId());
        }
        Messages.get();
        new ConsoleJob(Messages.TerminateAlarm_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map terminationFails = AlarmList.this.session.bulkTerminateAlarms(alarmIds);
                if (!terminationFails.isEmpty()) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AlarmStateChangeFailureDialog dlg = new AlarmStateChangeFailureDialog((this).AlarmList.this.viewPart.getSite().getShell(), terminationFails);
                            if (dlg.open() == 0) {
                                return;
                            }
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.TerminateAlarm_ErrorMessage;
            }
        }.start();
    }

    private void createIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        Messages.get();
        new ConsoleJob(Messages.AlarmList_JobTitle_CreateTicket, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmList.this.session.openHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_JobError_CreateTicket;
            }
        }.start();
    }

    private void showIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        Messages.get();
        new ConsoleJob(Messages.AlarmList_JobTitle_ShowTicket, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String url = AlarmList.this.session.getHelpdeskIssueUrl(id);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                            browser.openURL(new URL(url));
                        }
                        catch (Exception e) {
                            Activator.logError("Exception in AlarmList.showIssue (url=\"" + url + "\")", e);
                            Shell shell = AlarmList.this.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmList_Error, (String)Messages.AlarmList_InternalError);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_JobError_ShowTicket;
            }
        }.start();
    }

    private void unlinkIssue() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        Messages.get();
        new ConsoleJob(Messages.AlarmList_JobTitle_UnlinkTicket, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmList.this.session.unlinkHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_JobError_UnlinkTicket;
            }
        }.start();
    }

    private void showObjectDetails() {
        IStructuredSelection selection = this.alarmSelectionProvider.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = this.session.findObjectById(((Alarm)selection.getFirstElement()).getSourceObjectId());
        if (object != null) {
            try {
                TabbedObjectView view = (TabbedObjectView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
                view.setObject(object);
            }
            catch (PartInitException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmList_Error, (String)(String.valueOf(Messages.AlarmList_OpenDetailsError) + e.getLocalizedMessage()));
            }
        }
    }

    public TreeViewer getViewer() {
        return this.alarmViewer;
    }

    public IAction getActionShowColors() {
        return this.actionShowColor;
    }

    public void setShowColors(boolean show) {
        this.labelProvider.setShowColor(show);
        this.actionShowColor.setChecked(show);
        this.alarmViewer.refresh();
        Activator.getDefault().getPreferenceStore().setValue("SHOW_ALARM_STATUS_COLORS", show);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.alarmFilter.setFilterString(text);
        this.alarmViewer.refresh(false);
    }

    public void enableFilter(boolean enable) {
        this.initShowfilter = enable;
        this.filterText.setVisible(this.initShowfilter);
        FormData fd = (FormData)this.alarmViewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.getContent().layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public Action getActionShowFilter() {
        return this.actionShowFilter;
    }

    public void setFilterCloseAction(Action action) {
        this.filterText.setCloseAction(action);
    }

    public boolean isFilterEnabled() {
        return this.initShowfilter;
    }

    public void setIsLocalSoundEnabled(boolean isLocalSoundEnabled) {
        this.isLocalNotificationsEnabled = isLocalSoundEnabled;
    }

    private class EventAttributeValueProvider
    implements SearchQueryAttributeValueProvider {
        private EventAttributeValueProvider() {
        }

        public String[] getValues() {
            NXCSession session = ConsoleSharedData.getSession();
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (AlarmHandle a : AlarmList.this.displayList.values()) {
                eventCodes.add(Long.valueOf(a.alarm.getSourceEventCode()));
            }
            List eventTemplates = session.findMultipleEventTemplates(eventCodes);
            if (eventTemplates.isEmpty()) {
                return null;
            }
            String[] values = new String[eventTemplates.size()];
            int i = 0;
            while (i < values.length) {
                values[i] = ((EventTemplate)eventTemplates.get(i)).getName();
                ++i;
            }
            return values;
        }
    }

    private class SourceAttributeValueProvider
    implements SearchQueryAttributeValueProvider {
        private SourceAttributeValueProvider() {
        }

        public String[] getValues() {
            NXCSession session = ConsoleSharedData.getSession();
            HashSet<Long> objectIdentifiers = new HashSet<Long>();
            for (AlarmHandle a : AlarmList.this.displayList.values()) {
                objectIdentifiers.add(a.alarm.getSourceObjectId());
            }
            List objects = session.findMultipleObjects(objectIdentifiers, false);
            if (objects.isEmpty()) {
                return null;
            }
            String[] values = new String[objects.size()];
            int i = 0;
            while (i < values.length) {
                values[i] = ((AbstractObject)objects.get(i)).getObjectName();
                ++i;
            }
            return values;
        }
    }

    private static class ZoneAttributeValueProvider
    implements SearchQueryAttributeValueProvider {
        private ZoneAttributeValueProvider() {
        }

        public String[] getValues() {
            NXCSession session = ConsoleSharedData.getSession();
            if (!session.isZoningEnabled()) {
                return null;
            }
            List zones = session.getAllZones();
            if (zones.isEmpty()) {
                return null;
            }
            String[] values = new String[zones.size()];
            int i = 0;
            while (i < values.length) {
                values[i] = ((Zone)zones.get(i)).getObjectName();
                ++i;
            }
            return values;
        }
    }
}

