/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableCell;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.TableComparisonChartConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public abstract class TableComparisonChartElement
extends ElementWidget {
    protected Chart chart;
    protected NXCSession session;
    protected TableComparisonChartConfig config;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;
    private Map<String, Integer> instanceMap = new HashMap<String, Integer>(16);
    private boolean chartInitialized = false;

    public TableComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.session = ConsoleSharedData.getSession();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TableComparisonChartElement.this.refreshController != null) {
                    TableComparisonChartElement.this.refreshController.dispose();
                }
            }
        });
    }

    protected void startRefreshTimer() {
        if (this.config == null || this.config.getDataColumn() == null) {
            return;
        }
        this.refreshController = new ViewRefreshController(this.viewPart, this.config.getRefreshRate(), new Runnable(){

            @Override
            public void run() {
                if (TableComparisonChartElement.this.isDisposed()) {
                    return;
                }
                TableComparisonChartElement.this.refreshData();
            }
        });
        this.refreshData();
    }

    protected void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.TableComparisonChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table data = TableComparisonChartElement.this.session.getTableLastValues(TableComparisonChartElement.this.config.getNodeId(), TableComparisonChartElement.this.config.getDciId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).TableComparisonChartElement.this.chart.isDisposed()) {
                            TableComparisonChartElement.this.updateChart(data);
                        }
                        (this).TableComparisonChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.TableComparisonChartElement_JobError;
            }

            protected void jobFailureHandler() {
                TableComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }
        };
        job.setUser(false);
        job.start();
    }

    private void updateChart(Table data) {
        String instanceColumn;
        String string = instanceColumn = this.config.getInstanceColumn() != null ? this.config.getInstanceColumn() : "";
        if (instanceColumn == null) {
            return;
        }
        int icIndex = data.getColumnIndex(instanceColumn);
        final int dcIndex = data.getColumnIndex(this.config.getDataColumn());
        if (icIndex == -1 || dcIndex == -1) {
            return;
        }
        if (this.config.isSortOnDataColumn()) {
            data.sort((Comparator)new Comparator<TableRow>(){

                @Override
                public int compare(TableRow row1, TableRow row2) {
                    TableCell c1 = row1.get(dcIndex);
                    TableCell c2 = row2.get(dcIndex);
                    String s1 = c1 != null ? c1.getValue() : "";
                    String s2 = c2 != null ? c2.getValue() : "";
                    int result = 0;
                    try {
                        double value1 = Double.parseDouble(s1);
                        double value2 = Double.parseDouble(s2);
                        result = Double.compare(value1, value2);
                    }
                    catch (NumberFormatException e) {
                        result = s1.compareToIgnoreCase(s2);
                    }
                    return TableComparisonChartElement.this.config.isSortDescending() ? -result : result;
                }
            });
            this.instanceMap.clear();
            this.chart.removeAllParameters();
        }
        boolean rebuild = false;
        int i = 0;
        while (i < data.getRowCount()) {
            block13: {
                Integer index;
                double value;
                block14: {
                    String instance = data.getCellValue(i, icIndex);
                    if (instance == null) break block13;
                    try {
                        value = Double.parseDouble(data.getCellValue(i, dcIndex));
                    }
                    catch (NumberFormatException e) {
                        value = 0.0;
                    }
                    index = this.instanceMap.get(instance);
                    if (index != null) break block14;
                    if (this.instanceMap.size() >= 16 || value == 0.0 && this.config.isIgnoreZeroValues()) break block13;
                    index = this.chart.addParameter(new GraphItem(this.config.getNodeId(), this.config.getDciId(), DataOrigin.INTERNAL, DataType.INT32, Long.toString(this.config.getDciId()), instance, "%s", -1, -1));
                    this.instanceMap.put(instance, index);
                    rebuild = true;
                }
                this.chart.updateParameter(index.intValue(), value, false);
            }
            ++i;
        }
        if (!this.chartInitialized) {
            this.chart.rebuild();
            this.chartInitialized = true;
        } else if (rebuild) {
            this.chart.rebuild();
        } else {
            this.chart.refresh();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }
}

