/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import org.netxms.client.constants.TimeUnit;
import org.netxms.ui.eclipse.dashboard.widgets.internal.AbstractChartConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class LineChartConfig
extends AbstractChartConfig {
    @Element(required=false)
    private int timeUnits = TimeUnit.HOUR.getValue();
    @Element(required=false)
    private int timeRange = 1;
    @Element(required=false)
    private boolean showGrid = true;
    @Element(required=false)
    private boolean logScaleEnabled = false;
    @Element(required=false)
    private boolean useMultipliers = true;
    @Element(required=false)
    private boolean stacked = false;
    @Element(required=false)
    private int lineWidth = 2;
    @Element(required=false)
    private boolean area = false;
    @Element(required=false)
    private boolean interactive = false;

    public LineChartConfig() {
        this.setTranslucent(true);
    }

    public static LineChartConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (LineChartConfig)serializer.read(LineChartConfig.class, xml);
    }

    public int getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(int timeUnits) {
        this.timeUnits = timeUnits;
    }

    public int getTimeRange() {
        return this.timeRange;
    }

    public void setTimeRange(int timeRange) {
        this.timeRange = timeRange;
    }

    public long getTimeRangeMillis() {
        switch (TimeUnit.getByValue((int)this.timeUnits)) {
            case MINUTE: {
                return (long)this.timeRange * 60L * 1000L;
            }
            case HOUR: {
                return (long)this.timeRange * 60L * 60L * 1000L;
            }
            case DAY: {
                return (long)this.timeRange * 24L * 60L * 60L * 1000L;
            }
        }
        return 0L;
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
    }

    public boolean isLogScaleEnabled() {
        return this.logScaleEnabled;
    }

    public void setLogScaleEnabled(boolean logScaleEnabled) {
        this.logScaleEnabled = logScaleEnabled;
    }

    public boolean isUseMultipliers() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public boolean isArea() {
        return this.area;
    }

    public void setArea(boolean area) {
        this.area = area;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }
}

