/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.netxms.client.NXCException;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.NodeComponentViewerTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfaceListLabelProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.InterfacesTabFilter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class InterfacesTab
extends NodeComponentViewerTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ALIAS = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_INDEX = 4;
    public static final int COLUMN_PHYSICAL_LOCATION = 5;
    public static final int COLUMN_MTU = 6;
    public static final int COLUMN_SPEED = 7;
    public static final int COLUMN_DESCRIPTION = 8;
    public static final int COLUMN_MAC_ADDRESS = 9;
    public static final int COLUMN_IP_ADDRESS = 10;
    public static final int COLUMN_VLAN = 11;
    public static final int COLUMN_PEER_NODE = 12;
    public static final int COLUMN_PEER_INTERFACE = 13;
    public static final int COLUMN_PEER_MAC_ADDRESS = 14;
    public static final int COLUMN_PEER_IP_ADDRESS = 15;
    public static final int COLUMN_PEER_PROTOCOL = 16;
    public static final int COLUMN_ADMIN_STATE = 17;
    public static final int COLUMN_OPER_STATE = 18;
    public static final int COLUMN_EXPECTED_STATE = 19;
    public static final int COLUMN_STATUS = 20;
    public static final int COLUMN_8021X_PAE_STATE = 21;
    public static final int COLUMN_8021X_BACKEND_STATE = 22;
    private InterfaceListLabelProvider labelProvider;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private boolean hideSubInterfaces = false;

    @Override
    protected void createTabContent(Composite parent) {
        super.createTabContent(parent);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.hideSubInterfaces = InterfacesTab.safeCast(settings.get("InterfacesTab.hideSubInterfaces"), settings.getBoolean("InterfacesTab.hideSubInterfaces"), this.hideSubInterfaces);
        this.filterText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                settings.put("InterfacesTab.hideSubInterfaces", InterfacesTab.this.hideSubInterfaces);
            }
        });
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces");
        State state = command.getState("org.netxms.ui.eclipse.objectview.commands.hideSubInterfaces.state");
        state.setValue((Object)this.hideSubInterfaces);
        service.refreshElements(command.getId(), null);
    }

    @Override
    protected void createActions() {
        super.createActions();
        Messages.get();
        this.actionCopyMacAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(9);
            }
        };
        Messages.get();
        this.actionCopyIpAddressToClipboard = new Action(Messages.InterfacesTab_ActionCopyIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(10);
            }
        };
        Messages.get();
        this.actionCopyPeerNameToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerName){

            public void run() {
                InterfacesTab.this.copyToClipboard(12);
            }
        };
        Messages.get();
        this.actionCopyPeerMacToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerMAC){

            public void run() {
                InterfacesTab.this.copyToClipboard(14);
            }
        };
        Messages.get();
        this.actionCopyPeerIpToClipboard = new Action(Messages.InterfacesTab_ActionCopyPeerIP){

            public void run() {
                InterfacesTab.this.copyToClipboard(15);
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer);
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(3).toArray());
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    public void hideSubInterfaces(boolean hide) {
        this.hideSubInterfaces = hide;
        ((InterfacesTabFilter)this.filter).setHideSubInterfaces(hide);
        this.viewer.refresh();
    }

    @Override
    protected void createViewer() {
        String[] stringArray = new String[23];
        Messages.get();
        stringArray[0] = Messages.InterfacesTab_ColId;
        Messages.get();
        stringArray[1] = Messages.InterfacesTab_ColName;
        Messages.get();
        stringArray[2] = Messages.InterfacesTab_Alias;
        Messages.get();
        stringArray[3] = Messages.InterfacesTab_ColIfType;
        Messages.get();
        stringArray[4] = Messages.InterfacesTab_ColIfIndex;
        stringArray[5] = "Location";
        Messages.get();
        stringArray[6] = Messages.InterfacesTab_MTU;
        Messages.get();
        stringArray[7] = Messages.InterfacesTab_Speed;
        Messages.get();
        stringArray[8] = Messages.InterfacesTab_ColDescription;
        Messages.get();
        stringArray[9] = Messages.InterfacesTab_ColMacAddr;
        Messages.get();
        stringArray[10] = Messages.InterfacesTab_ColIpAddr;
        stringArray[11] = "VLAN";
        Messages.get();
        stringArray[12] = Messages.InterfacesTab_ColPeerNode;
        stringArray[13] = "Peer interface";
        Messages.get();
        stringArray[14] = Messages.InterfacesTab_ColPeerMAC;
        Messages.get();
        stringArray[15] = Messages.InterfacesTab_ColPeerIP;
        Messages.get();
        stringArray[16] = Messages.InterfacesTab_PeerDiscoveryProtocol;
        Messages.get();
        stringArray[17] = Messages.InterfacesTab_ColAdminState;
        Messages.get();
        stringArray[18] = Messages.InterfacesTab_ColOperState;
        Messages.get();
        stringArray[19] = Messages.InterfacesTab_ColExpState;
        Messages.get();
        stringArray[20] = Messages.InterfacesTab_ColStatus;
        Messages.get();
        stringArray[21] = Messages.InterfacesTab_Col8021xPAE;
        Messages.get();
        stringArray[22] = Messages.InterfacesTab_Col8021xBackend;
        String[] names = stringArray;
        int[] widths = new int[]{60, 150, 150, 150, 70, 100, 70, 90, 150, 100, 90, 80, 150, 150, 100, 90, 80, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new InterfacesTabFilter();
        ((InterfacesTabFilter)this.filter).setHideSubInterfaces(this.hideSubInterfaces);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V7");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)InterfacesTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"InterfaceTable.V7");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.labelProvider.setNode((AbstractNode)object);
        super.objectChanged(object);
    }

    @Override
    public String getFilterSettingName() {
        return "InterfacesTab.showFilter";
    }

    @Override
    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface;
    }

    @Override
    protected void syncAdditionalObjects(AbstractObject object) throws IOException, NXCException {
        ArrayList<Long> additionalSyncInterfaces = new ArrayList<Long>();
        for (AbstractObject obj : object.getAllChildren(3)) {
            long id = ((Interface)obj).getPeerInterfaceId();
            if (id == 0L) continue;
            additionalSyncInterfaces.add(id);
        }
        if (!additionalSyncInterfaces.isEmpty()) {
            this.session.syncMissingObjects(additionalSyncInterfaces, true, 2);
        }
    }
}

