/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.base.views.ConfigurationPerspective;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PinboardPerspective;
import org.netxms.nxmc.base.windows.MainWindow;
import org.netxms.nxmc.modules.alarms.AlarmsPerspective;
import org.netxms.nxmc.modules.businessservice.BusinessServicesPerspective;
import org.netxms.nxmc.modules.objects.DashboardsPerspective;
import org.netxms.nxmc.modules.objects.InfrastructurePerspective;
import org.netxms.nxmc.modules.objects.MapsPerspective;
import org.netxms.nxmc.modules.objects.NetworkPerspective;
import org.netxms.nxmc.modules.objects.TemplatesPerspective;
import org.netxms.nxmc.modules.worldmap.WorldMapPerspective;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Registry {
    public static final boolean IS_WEB_CLIENT = true;
    private Set<Perspective> perspectives = new HashSet();
    private NXCSession session = null;
    private TimeZone timeZone = null;
    private File stateDir = null;
    private MainWindow mainWindow = null;

    public static Registry getInstance() {
        Registry instance = (Registry)RWT.getUISession().getAttribute("netxms.registry");
        if (instance == null) {
            instance = new Registry();
            RWT.getUISession().setAttribute("netxms.registry", (Object)instance);
        }
        return instance;
    }

    public static Registry getInstance(Display display) {
        Registry instance = (Registry)RWT.getUISession((Display)display).getAttribute("netxms.registry");
        if (instance == null) {
            instance = new Registry();
            RWT.getUISession((Display)display).setAttribute("netxms.registry", (Object)instance);
        }
        return instance;
    }

    public static NXCSession getSession() {
        return Registry.getInstance().session;
    }

    public static NXCSession getSession(Display display) {
        return Registry.getInstance((Display)display).session;
    }

    public static TimeZone getTimeZone() {
        return Registry.getInstance().timeZone;
    }

    public static File getStateDir() {
        return Registry.getInstance().stateDir;
    }

    public static File getStateDir(Display display) {
        return Registry.getInstance((Display)display).stateDir;
    }

    public static MainWindow getMainWindow() {
        return Registry.getInstance().mainWindow;
    }

    public static Object getProperty(String name) {
        return RWT.getUISession().getAttribute("netxms." + name);
    }

    public static Object getProperty(String name, Display display) {
        return RWT.getUISession((Display)display).getAttribute("netxms." + name);
    }

    public static void setProperty(String name, Object value) {
        RWT.getUISession().setAttribute("netxms." + name, value);
    }

    private Registry() {
        this.perspectives.add(new AlarmsPerspective());
        this.perspectives.add(new NetworkPerspective());
        this.perspectives.add(new InfrastructurePerspective());
        this.perspectives.add(new MapsPerspective());
        this.perspectives.add(new DashboardsPerspective());
        this.perspectives.add(new TemplatesPerspective());
        this.perspectives.add(new BusinessServicesPerspective());
        this.perspectives.add(new ConfigurationPerspective());
        this.perspectives.add(new PinboardPerspective());
        this.perspectives.add(new WorldMapPerspective());
    }

    public List<Perspective> getPerspectives() {
        ArrayList<Perspective> result = new ArrayList<Perspective>(this.perspectives);
        result.sort((Comparator<Perspective>)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    public void setSession(NXCSession session) {
        this.session = session;
    }

    public void setServerTimeZone() {
        if (this.session != null) {
            String tz = this.session.getServerTimeZone();
            this.timeZone = TimeZone.getTimeZone(tz.replaceAll("[A-Za-z]+([\\+\\-][0-9]+).*", "GMT$1"));
        }
    }

    public void resetTimeZone() {
        this.timeZone = null;
    }

    public void setStateDir(File stateDir) {
        if (this.stateDir == null) {
            this.stateDir = stateDir;
        }
    }

    public void setMainWindow(MainWindow window) {
        if (this.mainWindow == null) {
            this.mainWindow = window;
        }
    }
}

