/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.packages.PackageInfo;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.dialogs.EditPackageMetadataDialog;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.PackageLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PackageManager
extends ConfigurationView {
    private static I18n i18n = LocalizationHelper.getI18n(PackageManager.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VERSION = 3;
    public static final int COLUMN_PLATFORM = 4;
    public static final int COLUMN_FILE = 5;
    public static final int COLUMN_COMMAND = 6;
    public static final int COLUMN_DESCRIPTION = 7;
    private List<PackageInfo> packageList = null;
    private SortableTableViewer viewer;
    private Action actionUploadToServer;
    private Action actionRemove;
    private Action actionEditMetadata;

    public PackageManager() {
        super(i18n.tr("Packages"), ResourceManager.getImageDescriptor((String)"icons/config-views/package-manager.png"), "PackageManager", true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Type"), i18n.tr("Version"), i18n.tr("Platform"), i18n.tr("File"), i18n.tr("Command"), i18n.tr("Description")};
        int[] widths = new int[]{70, 120, 100, 90, 120, 300, 300, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.viewer.setComparator((ViewerComparator)new PackageComparator());
        this.createActions();
        this.createPopupMenu();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionUploadToServer = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRemove = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditMetadata = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionUploadToServer);
        manager.add((IAction)this.actionEditMetadata);
        manager.add((IAction)this.actionRemove);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        manager.add((IAction)this.actionUploadToServer);
    }

    protected void fillLocalMenu(MenuManager manager) {
        manager.add((IAction)this.actionUploadToServer);
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void installPackage() {
        FileDialog fd = new FileDialog(this.getWindow().getShell(), 4096);
        fd.setText(i18n.tr("Select Package File"));
        WidgetHelper.setFileDialogFilterExtensions((FileDialog)fd, (String[])new String[]{"*.apkg", "*.exe", "*.msi", "*.msp", "*.msu", "*.npi", "*.tgz;*.tar.gz", "*.zip", "*.*"});
        WidgetHelper.setFileDialogFilterNames((FileDialog)fd, (String[])new String[]{i18n.tr("NetXMS Agent Package"), i18n.tr("Executable"), i18n.tr("Windows Installer Package"), i18n.tr("Windows Installer Patch"), i18n.tr("Windows Update Package"), i18n.tr("NetXMS Package Info"), i18n.tr("Compressed TAR Archive"), i18n.tr("ZIP Archive"), i18n.tr("All Files")});
        String packageFileName = fd.open();
        if (packageFileName == null) {
            return;
        }
        try {
            EditPackageMetadataDialog dlg;
            PackageInfo packageInfo;
            boolean showMetadataDialog = true;
            if (packageFileName.endsWith(".npi")) {
                packageInfo = new PackageInfo(new File(packageFileName));
                showMetadataDialog = false;
            } else {
                File packageFile = new File(packageFileName);
                String name = packageFile.getName();
                if (packageFileName.endsWith(".apkg")) {
                    Pattern pattern = Pattern.compile("^nxagent-([0-9]+\\.[0-9]+\\.[0-9]+)(-[a-zA-Z0-9.]+)?(-[a-zA-Z0-9_]+)?\\.apkg$", 2);
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.matches()) {
                        showMetadataDialog = false;
                        if (matcher.group(2) == null) {
                            packageInfo = new PackageInfo("nxagent", "NetXMS Agent Source Package", name, "agent-installer", "src", matcher.group(1), "");
                        } else {
                            Object platform;
                            Object os;
                            if (matcher.group(2).startsWith("-aix")) {
                                os = "AIX";
                                if (matcher.group(2).length() > 4) {
                                    os = (String)os + " " + matcher.group(2).substring(4);
                                }
                                platform = "AIX-powerpc";
                            } else if (matcher.group(2).equals("-hpux")) {
                                os = "HP-UX";
                                platform = "HP-UX" + matcher.group(3);
                            } else if (matcher.group(2).equals("-linux")) {
                                os = "Linux";
                                platform = matcher.group(3).equals("-arm") ? "Linux-arm*" : "Linux" + matcher.group(3);
                            } else if (matcher.group(2).equals("-solaris")) {
                                os = "Solaris";
                                String arch = matcher.group(3).equals("-sparc") ? "-sun4u" : (matcher.group(3).equals("-i386") ? "-i86pc" : matcher.group(3));
                                platform = "SunOS" + arch;
                            } else {
                                os = matcher.group(2).substring(1);
                                platform = (String)os + matcher.group(3);
                                showMetadataDialog = true;
                            }
                            packageInfo = new PackageInfo("nxagent", "NetXMS Agent for " + (String)os, name, "agent-installer", (String)platform, matcher.group(1), "");
                        }
                    } else {
                        packageInfo = new PackageInfo(name, "", name, "executable", "*", "", "");
                    }
                } else if (packageFileName.endsWith(".deb")) {
                    packageInfo = new PackageInfo(name.substring(0, name.length() - 4), "", name, "deb", "Linux-*", "", "");
                } else if (packageFileName.endsWith(".exe")) {
                    Pattern pattern = Pattern.compile("^nxagent-([0-9]+\\.[0-9]+\\.[0-9]+)(-x64)?\\.exe$", 2);
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.matches()) {
                        packageInfo = new PackageInfo("nxagent", "NetXMS Agent for Windows", name, "agent-installer", "windows-" + (matcher.group(2) == null ? "i386" : "x64"), matcher.group(1), "");
                        showMetadataDialog = false;
                    } else {
                        pattern = Pattern.compile("^nxagent-atm-([0-9]+\\.[0-9]+\\.[0-9]+)(-x64)?\\.exe$", 2);
                        matcher = pattern.matcher(name);
                        if (matcher.matches()) {
                            packageInfo = new PackageInfo("nxagent-atm", "NetXMS Agent for ATM", name, "agent-installer", "windows-" + (matcher.group(2) == null ? "i386" : "x64"), matcher.group(1), "");
                            showMetadataDialog = false;
                        } else {
                            packageInfo = new PackageInfo(name, "", name, "executable", "windows-x64", "", "");
                        }
                    }
                } else if (packageFileName.endsWith(".msi") || packageFileName.endsWith(".msp") || packageFileName.endsWith(".msu")) {
                    packageInfo = new PackageInfo(name.substring(0, name.lastIndexOf(46)), "", name, name.substring(name.lastIndexOf(46) + 1), "windows-x64", "", "");
                } else if (packageFileName.endsWith(".rpm")) {
                    packageInfo = new PackageInfo(name.substring(0, name.length() - 4), "", name, "rpm", "*", "", "");
                } else if (packageFileName.endsWith(".tar.gz") || packageFileName.endsWith(".tgz")) {
                    int suffixLen = packageFileName.endsWith(".tar.gz") ? 7 : 4;
                    packageInfo = new PackageInfo(name.substring(0, name.length() - suffixLen), "", name, "tgz", "*", "", "");
                } else {
                    packageInfo = packageFileName.endsWith(".zip") ? new PackageInfo(name.substring(0, name.length() - 4), "", name, "zip", "*", "", "") : new PackageInfo(name, "", name, "executable", "*", "", "");
                }
            }
            if (showMetadataDialog && (dlg = new EditPackageMetadataDialog(this.getWindow().getShell(), packageInfo)).open() != 0) {
                return;
            }
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        catch (IOException e) {
            MessageDialogHelper.openError((Shell)this.getWindow().getShell(), (String)i18n.tr("Error"), (String)(i18n.tr("Cannot open package information file: ") + e.getLocalizedMessage()));
        }
    }

    private void removePackage() {
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)i18n.tr("Confirm Package Delete"), (String)i18n.tr("Are you sure you wish to delete selected packages?"))) {
            return;
        }
        NXCSession session = Registry.getSession();
        Object[] packages = this.viewer.getStructuredSelection().toArray();
        ArrayList removedPackages = new ArrayList();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editPackageMetadata() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PackageInfo packageInfo = (PackageInfo)selection.getFirstElement();
        EditPackageMetadataDialog dlg = new EditPackageMetadataDialog(this.getWindow().getShell(), packageInfo);
        if (dlg.open() != 0) {
            return;
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

