/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.AccessControl;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListComparator;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.AccessListLabelProvider;
import org.netxms.nxmc.modules.users.dialogs.SelectUserDialog;
import org.xnap.commons.i18n.I18n;

public class AccessControl
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(AccessControl.class);
    private DataCollectionObject dco;
    private Set<AbstractUserObject> acl = new HashSet();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonRemove;
    private static final String[] info = new String[]{"Inherited from object access rights"};
    private NXCSession session;

    public AccessControl(DataCollectionObjectEditor editor) {
        super(i18n.tr("Access Control"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dco = this.editor.getObject();
        this.session = Registry.getSession();
        for (Long uid : this.dco.getAccessList()) {
            AbstractUserObject o = this.session.findUserDBObjectById(uid.longValue(), null);
            if (o == null) continue;
            this.acl.add(o);
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Restrict access to the following users"));
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AccessListComparator());
        this.viewer.getTable().setSortDirection(128);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.setViewerInput();
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(i18n.tr("Add"));
        this.buttonAdd.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(i18n.tr("Remove"));
        this.buttonRemove.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        this.getUsersAndRefresh();
        return dialogArea;
    }

    private void getUsersAndRefresh() {
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void setViewerInput() {
        if (this.acl.isEmpty()) {
            this.viewer.setInput((Object)info);
        } else {
            this.viewer.setInput((Object)this.acl.toArray());
        }
    }

    public void addUser() {
        SelectUserDialog dlg = new SelectUserDialog(this.getShell(), AbstractUserObject.class);
        if (dlg.open() == 0) {
            for (AbstractUserObject o : dlg.getSelection()) {
                this.acl.add(o);
            }
            this.setViewerInput();
        }
    }

    public void removeUsers() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.acl.remove(o);
        }
        this.setViewerInput();
    }

    protected boolean applyChanges(boolean isApply) {
        ArrayList<Long> list = new ArrayList<Long>(this.acl.size());
        for (AbstractUserObject o : this.acl) {
            list.add(o.getId());
        }
        this.dco.setAccessList(list);
        return true;
    }

    protected void performDefaults() {
        this.acl.clear();
        this.setViewerInput();
    }
}

