/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.views.AlarmsView;
import org.netxms.nxmc.modules.businessservice.views.BusinessServiceAvailabilityView;
import org.netxms.nxmc.modules.businessservice.views.BusinessServiceChecksView;
import org.netxms.nxmc.modules.datacollection.views.DataCollectionView;
import org.netxms.nxmc.modules.datacollection.views.PerformanceView;
import org.netxms.nxmc.modules.datacollection.views.SummaryDataCollectionView;
import org.netxms.nxmc.modules.filemanager.views.AgentFileManager;
import org.netxms.nxmc.modules.networkmaps.views.PredefinedMap;
import org.netxms.nxmc.modules.objects.ObjectCreateMenuManager;
import org.netxms.nxmc.modules.objects.ObjectMenuFactory;
import org.netxms.nxmc.modules.objects.SubtreeType;
import org.netxms.nxmc.modules.objects.views.ChassisView;
import org.netxms.nxmc.modules.objects.views.Dot1xStatusView;
import org.netxms.nxmc.modules.objects.views.EntityMIBView;
import org.netxms.nxmc.modules.objects.views.HardwareInventoryView;
import org.netxms.nxmc.modules.objects.views.InterfacesView;
import org.netxms.nxmc.modules.objects.views.MaintenanceJournalView;
import org.netxms.nxmc.modules.objects.views.ObjectBrowser;
import org.netxms.nxmc.modules.objects.views.ObjectOverviewView;
import org.netxms.nxmc.modules.objects.views.PhysicalLinkView;
import org.netxms.nxmc.modules.objects.views.ProcessesView;
import org.netxms.nxmc.modules.objects.views.RackView;
import org.netxms.nxmc.modules.objects.views.ServicesView;
import org.netxms.nxmc.modules.objects.views.SoftwareInventoryView;
import org.netxms.nxmc.modules.objects.views.StatusMapView;
import org.netxms.nxmc.modules.objects.views.SwitchForwardingDatabaseView;
import org.netxms.nxmc.modules.snmp.views.MibExplorer;
import org.netxms.nxmc.modules.worldmap.views.ObjectGeoLocationView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.FontTools;
import org.xnap.commons.i18n.I18n;

public abstract class ObjectsPerspective
extends Perspective {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectsPerspective.class);
    private SubtreeType subtreeType;
    private Composite headerArea;
    private Label objectName;
    private ToolBar objectToolBar;
    private ToolBar objectMenuBar;
    private Image imageEditConfig;
    private Image imageExecuteScript;

    protected ObjectsPerspective(String id, String name, Image image, SubtreeType subtreeType) {
        super(id, name, image);
        this.subtreeType = subtreeType;
        this.imageEditConfig = ResourceManager.getImage((String)"icons/object-views/agent-config.png");
        this.imageExecuteScript = ResourceManager.getImage((String)"icons/object-views/script-executor.png");
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.enableNavigationHistory = true;
        configuration.hasSupplementalArea = false;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = true;
        configuration.hasHeaderArea = true;
        configuration.priority = 20;
    }

    protected void configureViews() {
        this.addNavigationView((NavigationView)new ObjectBrowser(this.getName(), null, this.subtreeType));
        this.addMainView((View)new AgentFileManager());
        this.addMainView((View)new AlarmsView());
        this.addMainView((View)new BusinessServiceAvailabilityView());
        this.addMainView((View)new BusinessServiceChecksView());
        this.addMainView((View)new ChassisView());
        this.addMainView((View)new DataCollectionView());
        this.addMainView((View)new Dot1xStatusView());
        this.addMainView((View)new EntityMIBView());
        this.addMainView((View)new HardwareInventoryView());
        this.addMainView((View)new InterfacesView());
        this.addMainView((View)new MaintenanceJournalView());
        this.addMainView((View)new MibExplorer());
        this.addMainView((View)new ObjectGeoLocationView());
        this.addMainView((View)new ObjectOverviewView());
        this.addMainView((View)new PerformanceView());
        this.addMainView((View)new PhysicalLinkView());
        this.addMainView((View)new PredefinedMap());
        this.addMainView((View)new ProcessesView());
        this.addMainView((View)new RackView());
        this.addMainView((View)new ServicesView());
        this.addMainView((View)new SoftwareInventoryView());
        this.addMainView((View)new StatusMapView());
        this.addMainView((View)new SummaryDataCollectionView());
        this.addMainView((View)new SwitchForwardingDatabaseView());
    }

    protected void createHeaderArea(Composite parent) {
        this.headerArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        this.headerArea.setLayout((Layout)layout);
        this.objectName = new Label(this.headerArea, 16384);
        this.objectName.setFont(FontTools.createTitleFont());
        Label separator = new Label(this.headerArea, 514);
        GridData gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 24;
        separator.setLayoutData((Object)gd);
        this.objectToolBar = new ToolBar(this.headerArea, 8519936);
        separator = new Label(this.headerArea, 514);
        gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 24;
        separator.setLayoutData((Object)gd);
        this.objectMenuBar = new ToolBar(this.headerArea, 8519936);
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        super.navigationSelectionChanged(selection);
        if (selection.getFirstElement() instanceof AbstractObject) {
            AbstractObject object = (AbstractObject)selection.getFirstElement();
            this.objectName.setText(object.getNameWithAlias());
            this.updateObjectToolBar(object);
            this.updateObjectMenuBar(object);
        } else {
            this.objectName.setText("");
        }
        this.headerArea.layout();
    }

    private void updateObjectToolBar(AbstractObject object) {
        for (ToolItem item : this.objectToolBar.getItems()) {
            item.dispose();
        }
        this.addObjectToolBarItem(i18n.tr("Properties"), SharedIcons.IMG_PROPERTIES, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.addObjectToolBarItem(i18n.tr("Execute script"), this.imageExecuteScript, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        if (object instanceof Node && ((Node)object).hasAgent()) {
            this.addObjectToolBarItem(i18n.tr("Edit agent configuration"), this.imageEditConfig, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.addObjectToolBarItem(i18n.tr("Delete"), SharedIcons.IMG_DELETE_OBJECT, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addObjectToolBarItem(String name, Image icon, Runnable handler) {
        ToolItem item = new ToolItem(this.objectToolBar, 8);
        item.setImage(icon);
        item.setToolTipText(name);
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateObjectMenuBar(AbstractObject object) {
        for (ToolItem item : this.objectMenuBar.getItems()) {
            item.dispose();
        }
        this.addObjectMenu(i18n.tr("Tools"), ObjectMenuFactory.createToolsMenu((IStructuredSelection)new StructuredSelection((Object)object), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(i18n.tr("Poll"), ObjectMenuFactory.createPollMenu((IStructuredSelection)new StructuredSelection((Object)object), null, (Control)this.objectToolBar, (ViewPlacement)new ViewPlacement((Perspective)this)));
        this.addObjectMenu(i18n.tr("Create"), (MenuManager)new ObjectCreateMenuManager(this.getWindow().getShell(), null, object));
    }

    private void addObjectMenu(String name, Menu menu) {
        if (menu != null && menu.getItemCount() != 0) {
            this.createMenuToolItem(name, null, menu);
        }
    }

    private void addObjectMenu(String name, MenuManager menuManager) {
        if (menuManager != null && !menuManager.isEmpty()) {
            this.createMenuToolItem(name, menuManager, null);
        }
    }

    private void createMenuToolItem(String name, MenuManager menuManager, Menu menu) {
        ToolItem item = new ToolItem(this.objectMenuBar, 8);
        item.setText("  " + name + " \u25be  ");
        item.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }
}

