/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.base.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.tools.ComparatorHelper;

public class InterfaceListComparator
extends ViewerComparator {
    private static final MacAddress ZERO_MAC_ADDRESS = new MacAddress();
    private NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        Interface iface1 = (Interface)e1;
        Interface iface2 = (Interface)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 22: {
                result = iface1.getDot1xBackendState() - iface2.getDot1xBackendState();
                break;
            }
            case 21: {
                result = iface1.getDot1xPaeState() - iface2.getDot1xPaeState();
                break;
            }
            case 17: {
                result = iface1.getAdminState() - iface2.getAdminState();
                break;
            }
            case 2: {
                result = ComparatorHelper.compareStringsNatural((String)iface1.getAlias(), (String)iface2.getAlias());
                break;
            }
            case 8: {
                result = ComparatorHelper.compareStringsNatural((String)iface1.getDescription(), (String)iface2.getDescription());
                break;
            }
            case 19: {
                result = iface1.getExpectedState() - iface2.getExpectedState();
                break;
            }
            case 0: {
                result = Long.signum(iface1.getObjectId() - iface2.getObjectId());
                break;
            }
            case 4: {
                result = iface1.getIfIndex() - iface2.getIfIndex();
                break;
            }
            case 10: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)iface1.getFirstUnicastAddress(), (InetAddress)iface2.getFirstUnicastAddress());
                break;
            }
            case 9: {
                result = iface1.getMacAddress().compareTo(iface2.getMacAddress());
                break;
            }
            case 6: {
                result = iface1.getMtu() - iface2.getMtu();
                break;
            }
            case 1: {
                result = ComparatorHelper.compareStringsNatural((String)iface1.getObjectName(), (String)iface2.getObjectName());
                break;
            }
            case 18: {
                result = iface1.getOperState() - iface2.getOperState();
                break;
            }
            case 13: {
                result = ComparatorHelper.compareStringsNatural((String)this.getPeerInterfaceName(iface1), (String)this.getPeerInterfaceName(iface2));
                break;
            }
            case 15: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)this.getPeerIpAddress(iface1), (InetAddress)this.getPeerIpAddress(iface2));
                break;
            }
            case 14: {
                result = this.getPeerMacAddress(iface1).compareTo(this.getPeerMacAddress(iface2));
                break;
            }
            case 12: {
                result = ComparatorHelper.compareStringsNatural((String)this.getPeerNodeName(iface1), (String)this.getPeerNodeName(iface2));
                break;
            }
            case 16: {
                result = this.getPeerProtocol(iface1).compareTo(this.getPeerProtocol(iface2));
                break;
            }
            case 5: {
                if (iface1.isPhysicalPort() && iface2.isPhysicalPort()) {
                    result = iface1.getChassis() - iface2.getChassis();
                    if (result == 0) {
                        result = iface1.getModule() - iface2.getModule();
                    }
                    if (result == 0) {
                        result = iface1.getPIC() - iface2.getPIC();
                    }
                    if (result != 0) break;
                    result = iface1.getPort() - iface2.getPort();
                    break;
                }
                if (iface1.isPhysicalPort()) {
                    result = 1;
                    break;
                }
                if (iface2.isPhysicalPort()) {
                    result = -1;
                    break;
                }
                result = 0;
                break;
            }
            case 7: {
                result = Long.signum(iface1.getSpeed() - iface2.getSpeed());
                break;
            }
            case 20: {
                result = iface1.getStatus().compareTo((Enum)iface2.getStatus());
                break;
            }
            case 3: {
                result = iface1.getIfType() - iface2.getIfType();
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private InetAddress getPeerIpAddress(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        if (peer == null) {
            return null;
        }
        if (!peer.getPrimaryIP().isValidUnicastAddress()) {
            return null;
        }
        return peer.getPrimaryIP().getAddress();
    }

    private MacAddress getPeerMacAddress(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getMacAddress() : ZERO_MAC_ADDRESS;
    }

    private String getPeerProtocol(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? iface.getPeerDiscoveryProtocol().toString() : "";
    }

    private String getPeerNodeName(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : "";
    }

    private String getPeerInterfaceName(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getObjectName() : "";
    }
}

