/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SshKeyPair;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.dialogs.SSHKeyEditDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.SSHKeyLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SSHKeys
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(SSHKeys.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NMAE = 1;
    private SortableTableViewer viewer;
    private String filterString = "";
    private Action actionCopyToClipboard;
    private Action actionImport;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionGenerateNew;
    private NXCSession session = Registry.getSession();
    private SessionListener listener;
    private List<SshKeyPair> keyList;

    public SSHKeys() {
        super(i18n.tr("SSH Keys"), ResourceManager.getImageDescriptor((String)"icons/config-views/ssh-keys.png"), "SSHKeys", true);
    }

    public void createContent(Composite parent) {
        String[] setColumnNames = new String[]{"ID", "Name"};
        int[] setColumnWidths = new int[]{150, 250};
        this.viewer = new SortableTableViewer(parent, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SSHKeyLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addFilter((ViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionCopyToClipboard);
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionEdit);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionImport);
        mgr.add((IAction)this.actionGenerateNew);
    }

    protected void fillLocalMenu(MenuManager manager) {
        manager.add((IAction)this.actionImport);
        manager.add((IAction)this.actionGenerateNew);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        manager.add((IAction)this.actionImport);
        manager.add((IAction)this.actionGenerateNew);
    }

    private void createActions() {
        this.actionImport = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionImport);
        this.actionGenerateNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+G", (IAction)this.actionGenerateNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+C", (IAction)this.actionCopyToClipboard);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyToClipboard() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SshKeyPair key = (SshKeyPair)selection.getFirstElement();
        WidgetHelper.copyToClipboard((String)key.getPublicKey());
    }

    private void deleteKey() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Key"), (String)i18n.tr("Are you sure you want to delete selected SSH keys?"))) {
            return;
        }
        ArrayList<SshKeyPair> list = new ArrayList<SshKeyPair>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            list.add((SshKeyPair)it.next());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editKey() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SshKeyPair key = (SshKeyPair)selection.getFirstElement();
        SSHKeyEditDialog dlg = new SSHKeyEditDialog(this.getWindow().getShell(), new SshKeyPair(key));
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void importKeys() {
        SSHKeyEditDialog dlg = new SSHKeyEditDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void generateKeys() {
        InputDialog dlg = new InputDialog(this.getWindow().getShell(), i18n.tr("Generate SSH Key"), i18n.tr("Key name"), "", (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().setFocus();
        }
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

