/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Cookable;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.ISimpleCompiler;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.util.reflect.ByteArrayClassLoader;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.ClassLoaderIClassLoader;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.JaninoOption;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.ReflectionIClass;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.ClassFile;

public class SimpleCompiler
extends Cookable
implements ISimpleCompiler {
    private static final Logger LOGGER = Logger.getLogger(SimpleCompiler.class.getName());
    private ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
    @Nullable
    private ClassLoaderIClassLoader classLoaderIClassLoader;
    @Nullable
    private ErrorHandler compileErrorHandler;
    @Nullable
    private WarningHandler warningHandler;
    private boolean debugSource;
    private boolean debugLines = this.debugSource = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    private boolean debugVars = this.debugSource;
    private int sourceVersion = -1;
    private int targetVersion = -1;
    private EnumSet<JaninoOption> options = EnumSet.noneOf(JaninoOption.class);
    @Nullable
    private ClassFile[] classFiles;
    @Nullable
    private Map<String, byte[]> getBytecodesCache;
    @Nullable
    private ClassLoader getClassLoaderCache;

    public static void main(String[] args) throws Exception {
        if (args.length >= 1 && "-help".equals(args[0])) {
            System.out.println("Usage:");
            System.out.println("    org.codehaus.janino.SimpleCompiler <source-file> <class-name> { <argument> }");
            System.out.println("Reads a compilation unit from the given <source-file> and invokes method");
            System.out.println("\"public static void main(String[])\" of class <class-name>, passing the");
            System.out.println("given <argument>s.");
            System.exit(1);
        }
        if (args.length < 2) {
            System.err.println("Source file and/or class name missing; try \"-help\".");
            System.exit(1);
        }
        String sourceFileName = args[0];
        String className = args[1];
        String[] arguments2 = new String[args.length - 2];
        System.arraycopy(args, 2, arguments2, 0, arguments2.length);
        ClassLoader cl = new SimpleCompiler(sourceFileName, new FileInputStream(sourceFileName)).getClassLoader();
        Class<?> c = cl.loadClass(className);
        Method m = c.getMethod("main", String[].class);
        m.invoke(null, new Object[]{arguments2});
    }

    public SimpleCompiler(@Nullable String fileName, Reader in) throws IOException, CompileException {
        this.cook(fileName, in);
    }

    public SimpleCompiler(@Nullable String fileName, InputStream is) throws IOException, CompileException {
        this.cook(fileName, is);
    }

    public SimpleCompiler(String fileName) throws IOException, CompileException {
        this.cookFile(fileName);
    }

    public SimpleCompiler(Scanner scanner2, @Nullable ClassLoader parentClassLoader) throws IOException, CompileException {
        this.setParentClassLoader(parentClassLoader);
        this.cook(scanner2);
    }

    public SimpleCompiler() {
    }

    @Override
    public void setParentClassLoader(@Nullable ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader != null ? parentClassLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public void setDebuggingInformation(boolean debugSource, boolean debugLines, boolean debugVars) {
        this.debugSource = debugSource;
        this.debugLines = debugLines;
        this.debugVars = debugVars;
    }

    @Override
    public final void cook(@Nullable String fileName, Reader r) throws CompileException, IOException {
        this.cook(new Scanner(fileName, r));
    }

    public void cook(Scanner scanner2) throws CompileException, IOException {
        Parser parser2 = new Parser(scanner2);
        parser2.setSourceVersion(this.sourceVersion);
        parser2.setWarningHandler(this.warningHandler);
        this.compileToClassLoader(parser2.parseAbstractCompilationUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cook(Java.AbstractCompilationUnit abstractCompilationUnit) throws CompileException {
        LOGGER.entering(null, "cook", abstractCompilationUnit);
        this.assertUncooked();
        ClassLoaderIClassLoader icl = this.classLoaderIClassLoader = new ClassLoaderIClassLoader(this.parentClassLoader);
        try {
            UnitCompiler unitCompiler = new UnitCompiler(abstractCompilationUnit, icl).options(this.options);
            unitCompiler.setTargetVersion(this.targetVersion);
            unitCompiler.setCompileErrorHandler(this.compileErrorHandler);
            unitCompiler.setWarningHandler(this.warningHandler);
            this.classFiles = unitCompiler.compileUnit(this.debugSource, this.debugLines, this.debugVars);
        }
        finally {
            this.classLoaderIClassLoader = null;
        }
    }

    public ClassFile[] getClassFiles() {
        return this.assertCooked();
    }

    @Override
    public void setSourceVersion(int version2) {
        this.sourceVersion = version2;
    }

    @Override
    public void setTargetVersion(int version2) {
        this.targetVersion = version2;
    }

    @Override
    public Map<String, byte[]> getBytecodes() {
        if (this.getBytecodesCache != null) {
            return this.getBytecodesCache;
        }
        this.getBytecodesCache = this.getBytecodes2();
        return this.getBytecodesCache;
    }

    private Map<String, byte[]> getBytecodes2() {
        HashMap<String, byte[]> result2 = new HashMap<String, byte[]>();
        for (ClassFile cf : this.getClassFiles()) {
            result2.put(cf.getThisClassName(), cf.toByteArray());
        }
        return result2;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.getClassLoaderCache != null) {
            return this.getClassLoaderCache;
        }
        this.getClassLoaderCache = this.getClassLoader2();
        return this.getClassLoaderCache;
    }

    private ClassLoader getClassLoader2() {
        final Map<String, byte[]> bytecode = this.getBytecodes();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new ByteArrayClassLoader(bytecode, SimpleCompiler.this.parentClassLoader);
            }
        });
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof SimpleCompiler)) {
            return false;
        }
        SimpleCompiler that = (SimpleCompiler)o;
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.assertCooked().equals(that.assertCooked());
    }

    public int hashCode() {
        return this.parentClassLoader.hashCode();
    }

    @Override
    public void setCompileErrorHandler(@Nullable ErrorHandler compileErrorHandler) {
        this.compileErrorHandler = compileErrorHandler;
    }

    @Override
    public void setWarningHandler(@Nullable WarningHandler warningHandler) {
        this.warningHandler = warningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.options;
    }

    public SimpleCompiler options(EnumSet<JaninoOption> options) {
        this.options = options;
        return this;
    }

    @Nullable
    protected Java.Type optionalClassToType(Location location, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return this.classToType(location, clazz);
    }

    protected Java.Type classToType(final Location location, final Class<?> clazz) {
        return new Java.Type(location){
            @Nullable
            private Java.SimpleType delegate;

            @Override
            @Nullable
            public <R, EX extends Throwable> R accept(Visitor.AtomVisitor<R, EX> visitor2) throws EX {
                return visitor2.visitType(this.getDelegate());
            }

            @Override
            @Nullable
            public <R, EX extends Throwable> R accept(Visitor.TypeVisitor<R, EX> visitor2) throws EX {
                return this.getDelegate().accept(visitor2);
            }

            @Override
            public String toString() {
                return this.getDelegate().toString();
            }

            private Java.Type getDelegate() {
                Class<?> class2;
                IClass iClass2;
                IClass iClass;
                block13: {
                    if (this.delegate != null) {
                        return this.delegate;
                    }
                    ClassLoaderIClassLoader icl = SimpleCompiler.this.classLoaderIClassLoader;
                    assert (icl != null);
                    try {
                        iClass = icl.loadIClass(Descriptor.fromClassName(clazz.getName()));
                    }
                    catch (ClassNotFoundException ex) {
                        throw new InternalCompilerException("Loading IClass \"" + clazz.getName() + "\": " + ex);
                    }
                    if (iClass == null) {
                        throw new InternalCompilerException("Cannot load class '" + clazz.getName() + "' through the parent loader");
                    }
                    iClass2 = iClass;
                    class2 = clazz;
                    do {
                        IClass ct;
                        if ((ct = iClass2.getComponentType()) == null) {
                            if (class2.getComponentType() != null) {
                                throw new InternalCompilerException("Array type/class inconsistency");
                            }
                            break block13;
                        }
                        iClass2 = ct;
                    } while ((class2 = class2.getComponentType()) != null);
                    throw new InternalCompilerException("Array type/class inconsistency");
                }
                if (class2.isPrimitive()) {
                    if (!iClass2.isPrimitive()) {
                        throw new InternalCompilerException("Primitive type/class inconsistency");
                    }
                } else {
                    if (iClass2.isPrimitive()) {
                        throw new InternalCompilerException("Primitive type/class inconsistency");
                    }
                    if (((ReflectionIClass)iClass2).getClazz() != class2) {
                        throw new InternalCompilerException("Class '" + class2.getName() + "' was loaded through a different loader");
                    }
                }
                this.delegate = new Java.SimpleType(location, iClass);
                return this.delegate;
            }
        };
    }

    protected Java.Type[] classesToTypes(Location location, @Nullable Class<?>[] classes) {
        if (classes == null) {
            return new Java.Type[0];
        }
        Java.Type[] types2 = new Java.Type[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            types2[i] = this.classToType(location, classes[i]);
        }
        return types2;
    }

    protected final ClassLoader compileToClassLoader(Java.AbstractCompilationUnit abstractCompilationUnit) throws CompileException {
        this.cook(abstractCompilationUnit);
        return this.getClassLoader();
    }

    private void assertUncooked() {
        if (this.classFiles != null) {
            throw new IllegalStateException("Must only be called before \"cook()\"");
        }
    }

    private ClassFile[] assertCooked() {
        ClassFile[] result2 = this.classFiles;
        if (result2 == null) {
            throw new IllegalStateException("Must only be called after \"cook()\"");
        }
        return result2;
    }
}

