/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netxms.base.MacAddressFormatException;

public class MacAddress {
    private byte[] value;

    public MacAddress() {
        this.value = new byte[6];
        Arrays.fill(this.value, (byte)0);
    }

    public MacAddress(byte[] src) {
        if (src != null && src.length > 0) {
            this.value = Arrays.copyOf(src, src.length);
        } else {
            this.value = new byte[6];
            Arrays.fill(this.value, (byte)0);
        }
    }

    public boolean isNull() {
        for (byte b : this.value) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int ub = this.value[0] & 0xFF;
        if (ub < 16) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(ub));
        for (int i = 1; i < this.value.length; ++i) {
            sb.append(':');
            ub = this.value[i] & 0xFF;
            if (ub < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(ub));
        }
        return sb.toString().toUpperCase();
    }

    public boolean equals(Object other) {
        if (other instanceof MacAddress) {
            return Arrays.equals(this.value, ((MacAddress)other).value);
        }
        return super.equals(other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public static MacAddress parseMacAddress(String str) throws MacAddressFormatException {
        return MacAddress.parseMacAddress(str, true);
    }

    public static MacAddress parseMacAddress(String str, boolean fullMac) throws MacAddressFormatException {
        Pattern pattern = fullMac ? Pattern.compile("^([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?$") : Pattern.compile("^([0-9a-fA-F]{2})[ :-]?([0-9a-fA-F]{2})[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?[ .:-]?([0-9a-fA-F]{2})?[ :-]?([0-9a-fA-F]{2})?$");
        Matcher matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            int count2 = matcher.groupCount();
            ArrayList<Byte> byteList = new ArrayList<Byte>();
            try {
                for (int i = 0; i < count2; ++i) {
                    if (matcher.group(i + 1) == null) continue;
                    byteList.add((byte)Integer.parseInt(matcher.group(i + 1), 16));
                }
            }
            catch (NumberFormatException e) {
                throw new MacAddressFormatException();
            }
            byte[] bytes = new byte[byteList.size()];
            for (int i = 0; i < byteList.size(); ++i) {
                bytes[i] = (Byte)byteList.get(i);
            }
            return new MacAddress(bytes);
        }
        pattern = fullMac ? Pattern.compile("^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$") : Pattern.compile("^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$|^([0-9a-fA-F]{3})\\.([0-9a-fA-F]{3})$");
        matcher = pattern.matcher(str.trim());
        if (matcher.matches()) {
            int i;
            int count3 = matcher.groupCount();
            ArrayList<Byte> byteList = new ArrayList<Byte>();
            try {
                int j = 0;
                for (i = 1; i <= count3; i += 2) {
                    int left = Integer.parseInt(matcher.group(i), 16);
                    int right = Integer.parseInt(matcher.group(i + 1), 16);
                    byteList.add(j++, (byte)(left >> 4));
                    byteList.add(j++, (byte)((left & 0xF) << 4 | right >> 8));
                    byteList.add(j++, (byte)(right & 0xFF));
                }
            }
            catch (NumberFormatException e) {
                throw new MacAddressFormatException();
            }
            byte[] bytes = new byte[byteList.size()];
            for (i = 0; i < byteList.size(); ++i) {
                bytes[i] = (Byte)byteList.get(i);
            }
            return new MacAddress(bytes);
        }
        throw new MacAddressFormatException();
    }

    public byte[] getValue() {
        return Arrays.copyOf(this.value, this.value.length);
    }

    public int compareTo(MacAddress dst) {
        if (dst == null) {
            return 1;
        }
        int len = Math.min(this.value.length, dst.value.length);
        for (int i = 0; i < len; ++i) {
            int v1 = this.value[i] & 0xFF;
            int v2 = dst.value[i] & 0xFF;
            if (v1 < v2) {
                return -1;
            }
            if (v1 <= v2) continue;
            return 1;
        }
        return this.value.length - dst.value.length;
    }
}

