/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.InetAddress;
import java.util.Date;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;

public class AgentTunnel {
    private int id;
    private UUID guid;
    private InetAddress address;
    private UUID agentId;
    private byte[] hardwareId;
    private String systemName;
    private String systemInformation;
    private String platformName;
    private String agentVersion;
    private long nodeId;
    private int zoneUIN;
    private Date certificateExpirationTime;
    private Date connectionTime;
    private int activeChannelCount;
    private String hostname;
    private boolean agentProxy;
    private boolean snmpProxy;
    private boolean snmpTrapProxy;
    private boolean userAgentInstalled;
    private boolean syslogProxy;

    protected AgentTunnel(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt32(baseId);
        this.guid = msg2.getFieldAsUUID(baseId + 1L);
        this.nodeId = msg2.getFieldAsInt64(baseId + 2L);
        this.address = msg2.getFieldAsInetAddress(baseId + 3L);
        this.systemName = msg2.getFieldAsString(baseId + 4L);
        this.systemInformation = msg2.getFieldAsString(baseId + 5L);
        this.platformName = msg2.getFieldAsString(baseId + 6L);
        this.agentVersion = msg2.getFieldAsString(baseId + 7L);
        this.activeChannelCount = msg2.getFieldAsInt32(baseId + 8L);
        this.zoneUIN = msg2.getFieldAsInt32(baseId + 9L);
        this.hostname = msg2.getFieldAsString(baseId + 10L);
        this.agentId = msg2.getFieldAsUUID(baseId + 11L);
        this.userAgentInstalled = msg2.getFieldAsBoolean(baseId + 12L);
        this.agentProxy = msg2.getFieldAsBoolean(baseId + 13L);
        this.snmpProxy = msg2.getFieldAsBoolean(baseId + 14L);
        this.snmpTrapProxy = msg2.getFieldAsBoolean(baseId + 15L);
        this.certificateExpirationTime = msg2.getFieldAsDate(baseId + 16L);
        this.hardwareId = msg2.getFieldAsBinary(baseId + 17L);
        this.syslogProxy = msg2.getFieldAsBoolean(baseId + 18L);
        this.connectionTime = msg2.getFieldAsDate(baseId + 22L);
    }

    public boolean isBound() {
        return this.nodeId != 0L;
    }

    public int getId() {
        return this.id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public UUID getAgentId() {
        return this.agentId != null ? this.agentId : NXCommon.EMPTY_GUID;
    }

    public byte[] getHardwareId() {
        return this.hardwareId;
    }

    public String getHardwareIdAsText() {
        if (this.hardwareId == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : this.hardwareId) {
            int i = Byte.toUnsignedInt(b);
            if (i < 10) {
                sb.append('0');
            }
            sb.append(Integer.toString(i, 16));
        }
        return sb.toString();
    }

    public Date getCertificateExpirationTime() {
        return this.certificateExpirationTime;
    }

    public Date getConnectionTime() {
        return this.connectionTime;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getSystemInformation() {
        return this.systemInformation;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }

    public int getActiveChannelCount() {
        return this.activeChannelCount;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean isAgentProxy() {
        return this.agentProxy;
    }

    public boolean isSnmpProxy() {
        return this.snmpProxy;
    }

    public boolean isSnmpTrapProxy() {
        return this.snmpTrapProxy;
    }

    public boolean isSyslogProxy() {
        return this.syslogProxy;
    }

    public boolean isUserAgentInstalled() {
        return this.userAgentInstalled;
    }

    public String toString() {
        return "AgentTunnel [id=" + this.id + ", guid=" + this.guid + ", address=" + this.address + ", nodeId=" + this.nodeId + ", systemName=" + this.systemName + ", hostname=" + this.hostname + ", systemInformation=" + this.systemInformation + ", platformName=" + this.platformName + ", agentVersion=" + this.agentVersion + ", zoneUIN=" + this.zoneUIN + ", activeChannelCount=" + this.activeChannelCount + ", userAgentInstalled=" + this.userAgentInstalled + ", connectionTime=" + this.connectionTime + "]";
    }
}

