/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.businessservices;

import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.BusinessServiceCheckType;
import org.netxms.client.constants.BusinessServiceState;
import org.netxms.client.objects.interfaces.NodeItemPair;

public class BusinessServiceCheck
implements NodeItemPair {
    private long id;
    private long serviceId;
    private long prototypeServiceId;
    private long prototypeCheckId;
    private BusinessServiceCheckType type;
    private String description;
    private String script;
    private long objectId;
    private long dciId;
    private int threshold;
    private BusinessServiceState state;
    private String failureReason;

    public BusinessServiceCheck() {
        this.id = 0L;
        this.serviceId = 0L;
        this.prototypeServiceId = 0L;
        this.prototypeCheckId = 0L;
        this.type = BusinessServiceCheckType.NONE;
        this.description = null;
        this.script = null;
        this.objectId = 0L;
        this.dciId = 0L;
        this.threshold = 0;
        this.state = BusinessServiceState.OPERATIONAL;
    }

    public BusinessServiceCheck(BusinessServiceCheck src) {
        this.id = src.id;
        this.serviceId = src.serviceId;
        this.prototypeServiceId = src.prototypeServiceId;
        this.prototypeCheckId = src.prototypeCheckId;
        this.type = src.type;
        this.description = src.description;
        this.script = src.script;
        this.objectId = src.objectId;
        this.dciId = src.dciId;
        this.threshold = src.threshold;
        this.state = src.state;
    }

    public BusinessServiceCheck(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt64(baseId);
        this.type = BusinessServiceCheckType.getByValue(msg2.getFieldAsInt32(baseId + 1L));
        this.failureReason = msg2.getFieldAsString(baseId + 2L);
        this.dciId = msg2.getFieldAsInt64(baseId + 3L);
        this.objectId = msg2.getFieldAsInt64(baseId + 4L);
        this.threshold = msg2.getFieldAsInt32(baseId + 5L);
        this.description = msg2.getFieldAsString(baseId + 6L);
        this.script = msg2.getFieldAsString(baseId + 7L);
        this.state = BusinessServiceState.getByValue(msg2.getFieldAsInt32(baseId + 8L));
        this.prototypeServiceId = msg2.getFieldAsInt64(baseId + 9L);
        this.prototypeCheckId = msg2.getFieldAsInt64(baseId + 10L);
        this.serviceId = msg2.getFieldAsInt64(baseId + 11L);
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(769L, (int)this.id);
        msg2.setField(27L, this.description);
        msg2.setFieldInt16(391L, this.type.getValue());
        msg2.setFieldInt32(658L, (int)this.objectId);
        msg2.setFieldInt32(771L, (int)this.dciId);
        msg2.setField(228L, this.script);
        msg2.setFieldInt32(772L, this.threshold);
    }

    public BusinessServiceCheckType getCheckType() {
        return this.type;
    }

    public String getScript() {
        return this.script == null ? "" : this.script;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public long getId() {
        return this.id;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public long getPrototypeServiceId() {
        return this.prototypeServiceId;
    }

    public long getPrototypeCheckId() {
        return this.prototypeCheckId;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public long getDciId() {
        return this.dciId;
    }

    public BusinessServiceState getState() {
        return this.state;
    }

    public void setCheckType(BusinessServiceCheckType checkType) {
        this.type = checkType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public long getNodeId() {
        return this.objectId;
    }

    public void setId(long id) {
        this.id = id;
    }
}

