/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BusinessServiceState {
    OPERATIONAL(0),
    DEGRADED(2),
    FAILED(4);

    private static Logger logger;
    private static Map<Integer, BusinessServiceState> lookupTable;
    private int value;

    private BusinessServiceState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BusinessServiceState getByValue(int value) {
        BusinessServiceState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return DEGRADED;
        }
        return element;
    }

    static {
        logger = LoggerFactory.getLogger(BusinessServiceState.class);
        lookupTable = new HashMap<Integer, BusinessServiceState>();
        for (BusinessServiceState element : BusinessServiceState.values()) {
            lookupTable.put(element.value, element);
        }
    }
}

