/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.BulkDciUpdateElement;
import org.netxms.client.datacollection.DCOStatusHolder;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.LocalChangeListener;
import org.netxms.client.datacollection.RemoteChangeListener;

public class DataCollectionConfiguration {
    private NXCSession session;
    private long ownerId;
    private HashMap<Long, DataCollectionObject> items = new HashMap();
    private Object userData = null;
    private SessionListener listener;
    private RemoteChangeListener remoteChangeListener;
    private LocalChangeListener localChangeListener;

    public DataCollectionConfiguration(NXCSession session, long ownerId) {
        this.session = session;
        this.ownerId = ownerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(RemoteChangeListener changeListener) throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(41);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
        this.remoteChangeListener = changeListener;
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            NXCPMessage response;
            while (!(response = this.session.waitForMessage(42, msg2.getMessageId())).isEndOfSequence()) {
                DataCollectionObject dco;
                int type = response.getFieldAsInt32(411L);
                switch (type) {
                    case 1: {
                        dco = new DataCollectionItem(this, response);
                        break;
                    }
                    case 2: {
                        dco = new DataCollectionTable(this, response);
                        break;
                    }
                    default: {
                        dco = null;
                    }
                }
                if (dco == null) continue;
                this.items.put(dco.getId(), dco);
            }
        }
        this.listener = new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notificationHandler(SessionNotification n) {
                if (n.getSubCode() != DataCollectionConfiguration.this.ownerId) {
                    return;
                }
                if (n.getCode() == 1035) {
                    DataCollectionObject dco = (DataCollectionObject)n.getObject();
                    HashMap hashMap = DataCollectionConfiguration.this.items;
                    synchronized (hashMap) {
                        DataCollectionConfiguration.this.items.put(dco.getId(), dco instanceof DataCollectionItem ? new DataCollectionItem(DataCollectionConfiguration.this, (DataCollectionItem)dco) : new DataCollectionTable(DataCollectionConfiguration.this, (DataCollectionTable)dco));
                    }
                    if (DataCollectionConfiguration.this.remoteChangeListener != null) {
                        DataCollectionConfiguration.this.remoteChangeListener.onUpdate(dco);
                    }
                } else if (n.getCode() == 1036) {
                    long id = (Long)n.getObject();
                    HashMap hashMap = DataCollectionConfiguration.this.items;
                    synchronized (hashMap) {
                        DataCollectionConfiguration.this.items.remove(id);
                    }
                    if (DataCollectionConfiguration.this.remoteChangeListener != null) {
                        DataCollectionConfiguration.this.remoteChangeListener.onDelete(id);
                    }
                } else if (n.getCode() == 1037) {
                    DCOStatusHolder stHolder = (DCOStatusHolder)n.getObject();
                    DataCollectionConfiguration.this.updateItemStatusFromNotification(stHolder.getDciIdArray(), stHolder.getStatus());
                    if (DataCollectionConfiguration.this.remoteChangeListener != null) {
                        for (long id : stHolder.getDciIdArray()) {
                            DataCollectionConfiguration.this.remoteChangeListener.onStatusChange(id, stHolder.getStatus());
                        }
                    }
                }
            }
        };
        this.session.addListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDataCollectionList() throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(41);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        msg2.setField(668L, true);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            NXCPMessage response;
            this.items.clear();
            while (!(response = this.session.waitForMessage(42, msg2.getMessageId())).isEndOfSequence()) {
                DataCollectionObject dco;
                int type = response.getFieldAsInt32(411L);
                switch (type) {
                    case 1: {
                        dco = new DataCollectionItem(this, response);
                        break;
                    }
                    case 2: {
                        dco = new DataCollectionTable(this, response);
                        break;
                    }
                    default: {
                        dco = null;
                    }
                }
                if (dco == null) continue;
                this.items.put(dco.getId(), dco);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(46);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            this.items.clear();
        }
        this.session.removeListener(this.listener);
        this.remoteChangeListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollectionObject[] getItems() {
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            return this.items.values().toArray(new DataCollectionObject[this.items.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollectionObject findItem(long id) {
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            return this.items.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemStatusFromNotification(long[] idList, int status) {
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            for (int i = 0; i < idList.length; ++i) {
                DataCollectionObject o = this.items.get(idList[i]);
                if (o == null) continue;
                o.setStatus(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCollectionObject findItem(long id, Class<? extends DataCollectionObject> classFilter) {
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            DataCollectionObject o = this.items.get(id);
            if (o == null) {
                return null;
            }
            return classFilter.isInstance(o) ? o : null;
        }
    }

    @Deprecated
    public long createItem(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionItem(this, 0L));
    }

    @Deprecated
    public long createTable(DataCollectionObject object) throws IOException, NXCException {
        if (object != null) {
            return this.modifyObject(object);
        }
        return this.modifyObject(new DataCollectionTable(this, 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyObject(long dcObjectId) throws IOException, NXCException {
        HashMap<Long, DataCollectionObject> hashMap = this.items;
        synchronized (hashMap) {
            DataCollectionObject dco = this.items.get(dcObjectId);
            if (dco == null) {
                throw new NXCException(14);
            }
            this.modifyObject(dco);
        }
    }

    public long modifyObject(DataCollectionObject dco) throws IOException, NXCException {
        if (this.localChangeListener != null) {
            this.localChangeListener.onObjectChange();
        }
        NXCPMessage msg2 = this.session.newMessage(45);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        if (dco != null) {
            dco.fillMessage(msg2);
        }
        this.session.sendMessage(msg2);
        return this.session.waitForRCC(msg2.getMessageId()).getFieldAsInt64(43L);
    }

    private void copyObjectsInternal(long destNodeId, long[] items, boolean move) throws IOException, NXCException {
        if (this.localChangeListener != null) {
            this.localChangeListener.onObjectChange();
        }
        NXCPMessage msg2 = this.session.newMessage(91);
        msg2.setFieldInt32(109L, (int)this.ownerId);
        msg2.setFieldInt32(110L, (int)destNodeId);
        msg2.setFieldInt16(220L, move ? 1 : 0);
        msg2.setFieldInt32(111L, items.length);
        msg2.setField(112L, items);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
    }

    public void copyObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, false);
    }

    public void moveObjects(long destNodeId, long[] items) throws IOException, NXCException {
        this.copyObjectsInternal(destNodeId, items, true);
    }

    public void clearCollectedData(long itemId) throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(228);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        msg2.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
    }

    public void setObjectStatus(long[] items, int status) throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(104);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        msg2.setFieldInt16(48L, status);
        msg2.setFieldInt32(111L, items.length);
        msg2.setField(112L, items);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
    }

    public void deleteObject(long itemId) throws IOException, NXCException {
        if (this.localChangeListener != null) {
            this.localChangeListener.onObjectChange();
        }
        NXCPMessage msg2 = this.session.newMessage(44);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        msg2.setFieldInt32(43L, (int)itemId);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
        this.items.remove(itemId);
    }

    public void bulkUpdateDCIs(Collection<Long> idList, Collection<? extends BulkDciUpdateElement> fields) throws IOException, NXCException {
        if (this.localChangeListener != null) {
            this.localChangeListener.onObjectChange();
        }
        NXCPMessage msg2 = this.session.newMessage(420);
        msg2.setFieldInt32(3L, (int)this.ownerId);
        for (BulkDciUpdateElement bulkDciUpdateElement : fields) {
            bulkDciUpdateElement.setField(msg2);
        }
        msg2.setField(112L, idList);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    protected final NXCSession getSession() {
        return this.session;
    }

    public void setLocalChangeListener(LocalChangeListener listener) {
        this.localChangeListener = listener;
    }

    public void setRemoteChangeListener(RemoteChangeListener listener) {
        this.remoteChangeListener = listener;
    }
}

