/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.Threshold;

public class DataCollectionItem
extends DataCollectionObject {
    public static final int DCF_ALL_THRESHOLDS = 2;
    public static final int DCF_RAW_VALUE_OCTET_STRING = 4;
    public static final int DCF_SHOW_ON_OBJECT_TOOLTIP = 8;
    public static final int DCF_AGGREGATE_FUNCTION_MASK = 112;
    public static final int DCF_CALCULATE_NODE_STATUS = 1024;
    public static final int DCF_SHOW_IN_OBJECT_OVERVIEW = 2048;
    public static final int DCF_MULTIPLIERS_MASK = 196608;
    public static final int DCF_FUNCTION_SUM = 0;
    public static final int DCF_FUNCTION_AVG = 1;
    public static final int DCF_FUNCTION_MIN = 2;
    public static final int DCF_FUNCTION_MAX = 3;
    public static final int DELTA_NONE = 0;
    public static final int DELTA_SIMPLE = 1;
    public static final int DELTA_AVERAGE_PER_SECOND = 2;
    public static final int DELTA_AVERAGE_PER_MINUTE = 3;
    public static final int SNMP_RAWTYPE_NONE = 0;
    public static final int SNMP_RAWTYPE_INT32 = 1;
    public static final int SNMP_RAWTYPE_UINT32 = 2;
    public static final int SNMP_RAWTYPE_INT64 = 3;
    public static final int SNMP_RAWTYPE_UINT64 = 4;
    public static final int SNMP_RAWTYPE_DOUBLE = 5;
    public static final int SNMP_RAWTYPE_IP_ADDR = 6;
    public static final int SNMP_RAWTYPE_MAC_ADDR = 7;
    private DataType dataType;
    private int deltaCalculation;
    private int sampleCount;
    private int baseUnits;
    private int multiplier;
    private String customUnitName;
    private int snmpRawValueType;
    private ArrayList<Threshold> thresholds;
    private String predictionEngine;

    public DataCollectionItem(DataCollectionConfiguration owner, NXCPMessage msg2) {
        super(owner, msg2);
        this.dataType = DataType.getByValue(msg2.getFieldAsInt16(47L));
        this.deltaCalculation = msg2.getFieldAsInt32(105L);
        this.sampleCount = msg2.getFieldAsInt32(440L);
        this.baseUnits = msg2.getFieldAsInt32(322L);
        this.multiplier = msg2.getFieldAsInt32(323L);
        this.customUnitName = msg2.getFieldAsString(324L);
        this.snmpRawValueType = msg2.getFieldAsInt32(249L);
        this.predictionEngine = msg2.getFieldAsString(103L);
        int count2 = msg2.getFieldAsInt32(54L);
        this.thresholds = new ArrayList(count2);
        long varId = 0x20000000L;
        int i = 0;
        while (i < count2) {
            this.thresholds.add(new Threshold(msg2, varId));
            ++i;
            varId += 20L;
        }
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, long nodeId, long id) {
        super(owner, nodeId, id);
        this.dataType = DataType.INT32;
        this.deltaCalculation = 0;
        this.sampleCount = 0;
        this.baseUnits = 0;
        this.multiplier = 0;
        this.customUnitName = null;
        this.snmpRawValueType = 0;
        this.predictionEngine = "";
        this.thresholds = new ArrayList(0);
    }

    public DataCollectionItem(DataCollectionConfiguration owner, long id) {
        this(owner, owner.getOwnerId(), id);
    }

    public DataCollectionItem(long nodeId, long id) {
        this(null, nodeId, id);
    }

    protected DataCollectionItem() {
        this(null, 0L, 0L);
    }

    protected DataCollectionItem(DataCollectionConfiguration owner, DataCollectionItem src) {
        super(owner, src);
        this.dataType = src.dataType;
        this.deltaCalculation = src.deltaCalculation;
        this.sampleCount = src.sampleCount;
        this.baseUnits = src.baseUnits;
        this.multiplier = src.multiplier;
        this.customUnitName = src.customUnitName;
        this.snmpRawValueType = src.snmpRawValueType;
        this.thresholds = new ArrayList<Threshold>(src.thresholds);
        this.predictionEngine = src.predictionEngine;
    }

    @Override
    public void fillMessage(NXCPMessage msg2) {
        super.fillMessage(msg2);
        msg2.setFieldInt16(411L, 1);
        msg2.setFieldInt16(47L, this.dataType.getValue());
        msg2.setFieldInt16(105L, this.deltaCalculation);
        msg2.setFieldInt16(440L, this.sampleCount);
        msg2.setFieldInt16(249L, this.snmpRawValueType);
        msg2.setField(103L, this.predictionEngine);
        msg2.setFieldInt16(322L, this.baseUnits);
        msg2.setFieldInt32(323L, this.multiplier);
        if (this.customUnitName != null) {
            msg2.setField(324L, this.customUnitName);
        }
        msg2.setFieldInt32(54L, this.thresholds.size());
        long varId = 0x20000000L;
        int i = 0;
        while (i < this.thresholds.size()) {
            this.thresholds.get(i).fillMessage(msg2, varId);
            ++i;
            varId += 10L;
        }
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public int getDeltaCalculation() {
        return this.deltaCalculation;
    }

    public void setDeltaCalculation(int deltaCalculation) {
        this.deltaCalculation = deltaCalculation;
    }

    public boolean isProcessAllThresholds() {
        return (this.flags & 2L) != 0L;
    }

    public void setProcessAllThresholds(boolean processAllThresholds) {
        this.flags = processAllThresholds ? (this.flags |= 2L) : (this.flags &= 0xFFFFFFFFFFFFFFFDL);
    }

    public boolean isSnmpRawValueInOctetString() {
        return (this.flags & 4L) != 0L;
    }

    public void setSnmpRawValueInOctetString(boolean enable) {
        this.flags = enable ? (this.flags |= 4L) : (this.flags &= 0xFFFFFFFFFFFFFFFBL);
    }

    public boolean isShowOnObjectTooltip() {
        return (this.flags & 8L) != 0L;
    }

    public void setShowOnObjectTooltip(boolean show) {
        this.flags = show ? (this.flags |= 8L) : (this.flags &= 0xFFFFFFFFFFFFFFF7L);
    }

    public boolean isShowInObjectOverview() {
        return (this.flags & 0x800L) != 0L;
    }

    public void setShowInObjectOverview(boolean show) {
        this.flags = show ? (this.flags |= 0x800L) : (this.flags &= 0xFFFFFFFFFFFFF7FFL);
    }

    public int getAggregationFunction() {
        return (int)((this.flags & 0x70L) >> 4);
    }

    public void setAggregationFunction(int func) {
        this.flags = this.flags & 0xFFFFFFFFFFFFFF8FL | (long)((func & 7) << 4);
    }

    public int getBaseUnits() {
        return this.baseUnits;
    }

    public void setBaseUnits(int baseUnits) {
        this.baseUnits = baseUnits;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = multiplier;
    }

    public String getCustomUnitName() {
        return this.customUnitName;
    }

    public void setCustomUnitName(String customUnitName) {
        this.customUnitName = customUnitName;
    }

    public ArrayList<Threshold> getThresholds() {
        return this.thresholds;
    }

    public int getSnmpRawValueType() {
        return this.snmpRawValueType;
    }

    public void setSnmpRawValueType(int snmpRawValueType) {
        this.snmpRawValueType = snmpRawValueType;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public boolean isUsedForNodeStatusCalculation() {
        return (this.flags & 0x400L) != 0L;
    }

    public void setUsedForNodeStatusCalculation(boolean enable) {
        this.flags = enable ? (this.flags |= 0x400L) : (this.flags &= 0xFFFFFFFFFFFFFBFFL);
    }

    public String getPredictionEngine() {
        return this.predictionEngine;
    }

    public void setPredictionEngine(String predictionEngine) {
        this.predictionEngine = predictionEngine;
    }

    public int getMultipliersSelection() {
        return (int)((this.flags & 0x30000L) >> 16);
    }

    public void setMultiplierSelection(int mode) {
        this.flags = this.flags & 0xFFFFFFFFFFFCFFFFL | (long)((mode & 3) << 16);
    }
}

