/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;

public class ThresholdViolationSummary {
    private long nodeId;
    private List<DciValue> dciList;

    public ThresholdViolationSummary(NXCPMessage msg2, long baseId) {
        this.nodeId = msg2.getFieldAsInt64(baseId);
        int count2 = msg2.getFieldAsInt32(baseId + 1L);
        this.dciList = new ArrayList<DciValue>(count2);
        long varId = baseId + 2L;
        for (int i = 0; i < count2; ++i) {
            this.dciList.add(DciValue.createFromMessage(msg2, varId));
            varId += 50L;
        }
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public List<DciValue> getDciList() {
        return this.dciList;
    }

    public Severity getCurrentSeverity() {
        Severity severity = Severity.NORMAL;
        for (DciValue v : this.dciList) {
            if (v.getActiveThreshold().getCurrentSeverity().compareTo(severity) <= 0) continue;
            severity = v.getActiveThreshold().getCurrentSeverity();
        }
        return severity;
    }
}

