/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.LogRecordDetails;

public class Log {
    private NXCSession session;
    private int handle;
    private String name;
    private LinkedHashMap<String, LogColumn> columns;
    private String recordIdColumn;
    private String objectIdColumn;
    private long numRecords;
    private boolean hasDetailFields;

    public Log(NXCSession session, NXCPMessage msg2, String name) {
        this.session = session;
        this.name = name;
        this.handle = msg2.getFieldAsInt32(338L);
        this.recordIdColumn = msg2.getFieldAsString(705L);
        this.objectIdColumn = msg2.getFieldAsString(706L);
        this.hasDetailFields = msg2.getFieldAsBoolean(789L);
        int count2 = msg2.getFieldAsInt32(166L);
        this.columns = new LinkedHashMap(count2);
        long baseId = 0x10000000L;
        int i = 0;
        while (i < count2) {
            LogColumn c = new LogColumn(msg2, baseId);
            this.columns.put(c.getName(), c);
            ++i;
            baseId += 10L;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean hasDetailFields() {
        return this.hasDetailFields;
    }

    public Collection<LogColumn> getColumns() {
        return this.columns.values();
    }

    public String getColumnDescription(String columnName) {
        LogColumn col = this.columns.get(columnName);
        return col != null ? col.getDescription() : null;
    }

    public LogColumn getColumn(String columnName) {
        return this.columns.get(columnName);
    }

    public int getColumnIndex(String columnName) {
        int index = 0;
        for (LogColumn c : this.columns.values()) {
            if (c.getName().equals(columnName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public String getRecordIdColumnName() {
        return this.recordIdColumn;
    }

    public int getRecordIdColumnIndex() {
        return this.getColumnIndex(this.recordIdColumn);
    }

    public String getObjectIdColumnName() {
        return this.objectIdColumn;
    }

    public int getObjectIdColumnIndex() {
        return this.objectIdColumn != null ? this.getColumnIndex(this.objectIdColumn) : -1;
    }

    public void query(LogFilter filter) throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(63);
        msg2.setFieldInt32(338L, this.handle);
        filter.fillMessage(msg2);
        this.session.sendMessage(msg2);
        NXCPMessage response = this.session.waitForRCC(msg2.getMessageId(), 1800000);
        this.numRecords = response.getFieldAsInt64(167L);
    }

    public Table retrieveData(long startRow, long rowCount) throws IOException, NXCException {
        return this.retrieveData(startRow, rowCount, false);
    }

    public Table retrieveData(long startRow, long rowCount, boolean refresh) throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(43);
        msg2.setFieldInt32(338L, this.handle);
        msg2.setFieldInt64(339L, startRow);
        msg2.setFieldInt64(167L, rowCount);
        msg2.setFieldInt16(425L, refresh ? 1 : 0);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId(), 1800000);
        return this.session.receiveTable(msg2.getMessageId(), 143);
    }

    public long getNumRecords() {
        return this.numRecords;
    }

    public LogRecordDetails getRecordDetails(long recordId) throws IOException, NXCException {
        if (!this.hasDetailFields) {
            return null;
        }
        NXCPMessage msg2 = this.session.newMessage(412);
        msg2.setFieldInt32(338L, this.handle);
        msg2.setFieldInt64(704L, recordId);
        this.session.sendMessage(msg2);
        NXCPMessage response = this.session.waitForRCC(msg2.getMessageId());
        return new LogRecordDetails(recordId, response);
    }

    public void close() throws IOException, NXCException {
        NXCPMessage msg2 = this.session.newMessage(62);
        msg2.setFieldInt32(338L, this.handle);
        this.session.sendMessage(msg2);
        this.session.waitForRCC(msg2.getMessageId());
        this.handle = -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Log");
        sb.append("{session=").append(this.session);
        sb.append(", handle=").append(this.handle);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", columns=").append(this.columns);
        sb.append(", numRecords=").append(this.numRecords);
        sb.append(", hasDetailFields=").append(this.hasDetailFields);
        sb.append('}');
        return sb.toString();
    }
}

