/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;

public class NetworkMapElement {
    public static final int MAP_ELEMENT_GENERIC = 0;
    public static final int MAP_ELEMENT_OBJECT = 1;
    public static final int MAP_ELEMENT_DECORATION = 2;
    public static final int MAP_ELEMENT_DCI_CONTAINER = 3;
    public static final int MAP_ELEMENT_DCI_IMAGE = 4;
    public static final int MAP_ELEMENT_TEXT_BOX = 5;
    protected long id;
    protected int type;
    protected int x;
    protected int y;
    private int flags;

    public static NetworkMapElement createMapElement(NXCPMessage msg2, long baseId) {
        int type = msg2.getFieldAsInt32(baseId + 1L);
        switch (type) {
            case 1: {
                return new NetworkMapObject(msg2, baseId);
            }
            case 2: {
                return new NetworkMapDecoration(msg2, baseId);
            }
            case 3: {
                return new NetworkMapDCIContainer(msg2, baseId);
            }
            case 4: {
                return new NetworkMapDCIImage(msg2, baseId);
            }
            case 5: {
                return new NetworkMapTextBox(msg2, baseId);
            }
        }
        return new NetworkMapElement(msg2, baseId);
    }

    protected NetworkMapElement(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt64(baseId);
        this.type = msg2.getFieldAsInt32(baseId + 1L);
        this.x = msg2.getFieldAsInt32(baseId + 2L);
        this.y = msg2.getFieldAsInt32(baseId + 3L);
        this.flags = msg2.getFieldAsInt32(baseId + 4L);
    }

    public NetworkMapElement(long id) {
        this.id = id;
        this.type = 0;
        this.x = 0;
        this.y = 0;
        this.flags = 0;
    }

    public void fillMessage(NXCPMessage msg2, long baseId) {
        msg2.setFieldInt32(baseId, (int)this.id);
        msg2.setFieldInt16(baseId + 1L, this.type);
        msg2.setFieldInt32(baseId + 2L, this.x);
        msg2.setFieldInt32(baseId + 3L, this.y);
        msg2.setFieldInt32(baseId + 4L, this.flags);
    }

    public int getType() {
        return this.type;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public long getId() {
        return this.id;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkMapElement) {
            return ((NetworkMapElement)obj).id == this.id;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (int)this.id;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlag(int flags) {
        this.flags |= flags;
    }

    public void removeFlag(int flags) {
        this.flags &= ~flags;
    }
}

