/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.base.PostalAddress;
import org.netxms.base.annotations.Internal;
import org.netxms.client.AccessListElement;
import org.netxms.client.ModuleDataProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectUrl;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.client.objects.configs.CustomAttribute;
import org.netxms.client.services.ServiceManager;
import org.netxms.client.users.ResponsibleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObject {
    public static final int NETWORK = 1;
    public static final int SERVICEROOT = 2;
    public static final int TEMPLATEROOT = 3;
    public static final int ZONE0 = 4;
    public static final int POLICYROOT = 5;
    public static final int NETWORKMAPROOT = 6;
    public static final int DASHBOARDROOT = 7;
    public static final int REPORTROOT = 8;
    public static final int BUSINESSSERVICEROOT = 9;
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int OBJECT_BUSINESSSERVICEPROTOTYPE = 15;
    public static final int OBJECT_NETWORKMAPROOT = 19;
    public static final int OBJECT_NETWORKMAPGROUP = 20;
    public static final int OBJECT_NETWORKMAP = 21;
    public static final int OBJECT_DASHBOARDROOT = 22;
    public static final int OBJECT_DASHBOARD = 23;
    public static final int OBJECT_BUSINESSSERVICEROOT = 27;
    public static final int OBJECT_BUSINESSSERVICE = 28;
    public static final int OBJECT_MOBILEDEVICE = 31;
    public static final int OBJECT_RACK = 32;
    public static final int OBJECT_ACCESSPOINT = 33;
    public static final int OBJECT_CHASSIS = 35;
    public static final int OBJECT_DASHBOARDGROUP = 36;
    public static final int OBJECT_SENSOR = 37;
    public static final int OBJECT_CUSTOM = 10000;
    public static final int CALCULATE_DEFAULT = 0;
    public static final int CALCULATE_MOST_CRITICAL = 1;
    public static final int CALCULATE_SINGLE_THRESHOLD = 2;
    public static final int CALCULATE_MULTIPLE_THRESHOLDS = 3;
    public static final int PROPAGATE_DEFAULT = 0;
    public static final int PROPAGATE_UNCHANGED = 1;
    public static final int PROPAGATE_FIXED = 2;
    public static final int PROPAGATE_RELATIVE = 3;
    public static final int PROPAGATE_TRANSLATED = 4;
    private static final Logger logger = LoggerFactory.getLogger(AbstractObject.class);
    @Internal
    protected NXCSession session = null;
    protected long objectId = 0L;
    protected UUID guid;
    protected String objectName;
    protected String alias;
    protected String nameOnMap;
    protected int objectClass;
    protected int categoryId;
    protected int flags;
    protected ObjectStatus status = ObjectStatus.UNKNOWN;
    protected boolean isDeleted = false;
    protected boolean inMaintenanceMode = false;
    protected long maintenanceInitiatorId = 0L;
    protected long primaryZoneProxyId = 0L;
    protected long backupZoneProxyId = 0L;
    protected String comments;
    protected String commentsSource;
    protected GeoLocation geolocation;
    protected PostalAddress postalAddress;
    protected UUID mapImage;
    protected long drillDownObjectId;
    protected final HashSet<Long> trustedNodes = new HashSet(0);
    protected boolean inheritAccessRights = true;
    protected HashSet<AccessListElement> accessList = new HashSet(0);
    protected int statusCalculationMethod;
    protected int statusPropagationMethod;
    protected ObjectStatus fixedPropagatedStatus;
    protected int statusShift;
    protected ObjectStatus[] statusTransformation;
    protected int statusSingleThreshold;
    protected int[] statusThresholds;
    protected Date creationTime;
    protected final HashSet<Long> parents = new HashSet(0);
    protected final HashSet<Long> children = new HashSet(0);
    protected final List<Long> dashboards = new ArrayList<Long>(0);
    protected final Map<String, CustomAttribute> customAttributes = new HashMap<String, CustomAttribute>(0);
    protected final List<ObjectUrl> urls = new ArrayList<ObjectUrl>(0);
    protected final List<ResponsibleUser> responsibleUsers = new ArrayList<ResponsibleUser>(0);
    protected Map<String, Object> moduleData = null;
    @Internal
    private int effectiveRights = 0;
    @Internal
    private boolean effectiveRightsCached = false;

    protected AbstractObject(long id, NXCSession session) {
        this.objectId = id;
        this.session = session;
        this.guid = UUID.randomUUID();
        this.objectName = "unknown";
        this.objectClass = 0;
        this.comments = "";
        this.commentsSource = "";
        this.geolocation = new GeoLocation(false);
        this.postalAddress = new PostalAddress();
        this.statusCalculationMethod = 0;
        this.statusPropagationMethod = 0;
        this.fixedPropagatedStatus = ObjectStatus.NORMAL;
        this.statusShift = 0;
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.WARNING;
        this.statusTransformation[1] = ObjectStatus.MINOR;
        this.statusTransformation[2] = ObjectStatus.MAJOR;
        this.statusTransformation[3] = ObjectStatus.CRITICAL;
        this.statusSingleThreshold = 75;
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = 75;
        this.statusThresholds[1] = 75;
        this.statusThresholds[2] = 75;
        this.statusThresholds[3] = 75;
    }

    public AbstractObject(NXCPMessage msg2, NXCSession session) {
        Long[] d;
        this.session = session;
        this.objectId = msg2.getFieldAsInt32(3L);
        this.guid = msg2.getFieldAsUUID(222L);
        this.objectName = msg2.getFieldAsString(4L);
        this.alias = msg2.getFieldAsString(494L);
        this.nameOnMap = msg2.getFieldAsString(712L);
        this.objectClass = msg2.getFieldAsInt32(5L);
        this.categoryId = msg2.getFieldAsInt32(104L);
        this.flags = msg2.getFieldAsInt32(13L);
        this.isDeleted = msg2.getFieldAsBoolean(30L);
        this.status = ObjectStatus.getByValue(msg2.getFieldAsInt32(10L));
        this.inMaintenanceMode = msg2.getFieldAsBoolean(530L);
        this.maintenanceInitiatorId = msg2.getFieldAsInt64(703L);
        this.primaryZoneProxyId = msg2.getFieldAsInt64(638L);
        this.backupZoneProxyId = msg2.getFieldAsInt64(639L);
        this.comments = msg2.getFieldAsString(82L);
        this.commentsSource = msg2.getFieldAsString(777L);
        this.geolocation = new GeoLocation(msg2);
        this.postalAddress = new PostalAddress(msg2);
        this.mapImage = msg2.getFieldAsUUID(379L);
        this.drillDownObjectId = msg2.getFieldAsInt64(389L);
        this.creationTime = msg2.getFieldAsDate(240L);
        this.statusCalculationMethod = msg2.getFieldAsInt32(160L);
        this.statusPropagationMethod = msg2.getFieldAsInt32(183L);
        this.fixedPropagatedStatus = ObjectStatus.getByValue(msg2.getFieldAsInt32(184L));
        this.statusShift = msg2.getFieldAsInt32(185L);
        this.statusTransformation = new ObjectStatus[4];
        this.statusTransformation[0] = ObjectStatus.getByValue(msg2.getFieldAsInt32(186L));
        this.statusTransformation[1] = ObjectStatus.getByValue(msg2.getFieldAsInt32(187L));
        this.statusTransformation[2] = ObjectStatus.getByValue(msg2.getFieldAsInt32(188L));
        this.statusTransformation[3] = ObjectStatus.getByValue(msg2.getFieldAsInt32(189L));
        this.statusSingleThreshold = msg2.getFieldAsInt32(190L);
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = msg2.getFieldAsInt32(191L);
        this.statusThresholds[1] = msg2.getFieldAsInt32(192L);
        this.statusThresholds[2] = msg2.getFieldAsInt32(193L);
        this.statusThresholds[3] = msg2.getFieldAsInt32(194L);
        if (this.statusShift > Short.MAX_VALUE) {
            this.statusShift -= 65536;
        }
        int count2 = msg2.getFieldAsInt32(7L);
        int i = 0;
        long id = 12288L;
        while (i < count2) {
            this.parents.add(msg2.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count2 = msg2.getFieldAsInt32(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count2) {
            this.children.add(msg2.getFieldAsInt64(id));
            ++i;
            ++id;
        }
        count2 = msg2.getFieldAsInt32(306L);
        if (count2 > 0) {
            Long[] nodes = msg2.getFieldAsUInt32ArrayEx(307L);
            this.trustedNodes.addAll(Arrays.asList(nodes));
        }
        if ((d = msg2.getFieldAsUInt32ArrayEx(528L)) != null && d.length > 0) {
            this.dashboards.addAll(Arrays.asList(d));
        }
        count2 = msg2.getFieldAsInt32(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count2) {
            this.customAttributes.put(msg2.getFieldAsString(id), new CustomAttribute(msg2, id + 1L));
            ++i;
            id += 4L;
        }
        count2 = msg2.getFieldAsInt32(575L);
        i = 0;
        id = 0x74000000L;
        while (i < count2) {
            this.urls.add(new ObjectUrl(msg2, id));
            ++i;
            id += 10L;
        }
        this.inheritAccessRights = msg2.getFieldAsBoolean(33L);
        count2 = msg2.getFieldAsInt32(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count2) {
            this.accessList.add(new AccessListElement(msg2.getFieldAsInt64(id), msg2.getFieldAsInt32(id2)));
            ++i;
            ++id;
            ++id2;
        }
        count2 = msg2.getFieldAsInt32(476L);
        if (count2 > 0) {
            this.moduleData = new HashMap<String, Object>(count2);
            i = 0;
            id = 0x71000000L;
            while (i < count2) {
                String module = msg2.getFieldAsString(id);
                ModuleDataProvider p = (ModuleDataProvider)ServiceManager.getServiceHandler(module, ModuleDataProvider.class);
                if (p != null) {
                    this.moduleData.put(module, p.createModuleData(msg2, id + 1L));
                } else {
                    logger.error("Unable to find data provider for module " + module);
                }
                ++i;
                id += 0x100000L;
            }
        }
        count2 = msg2.getFieldAsInt32(615L);
        id = 0x69000000L;
        i = 0;
        while (i < count2) {
            this.responsibleUsers.add(new ResponsibleUser(msg2, id));
            ++i;
            id += 10L;
        }
    }

    public boolean isDefaultImage() {
        return this.mapImage == null || this.mapImage.equals(NXCommon.EMPTY_GUID);
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChildren() {
        return this.children.iterator();
    }

    public AccessListElement[] getAccessList() {
        return this.accessList.toArray(new AccessListElement[this.accessList.size()]);
    }

    public List<ObjectUrl> getUrls() {
        return new ArrayList<ObjectUrl>(this.urls);
    }

    public boolean hasUrls() {
        return !this.urls.isEmpty();
    }

    public String getCommentsSource() {
        return this.commentsSource;
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getAlias() {
        return this.alias != null ? this.alias : "";
    }

    public String getNameOnMap() {
        return this.nameOnMap != null && !this.nameOnMap.isEmpty() ? this.nameOnMap : this.objectName;
    }

    public String getConfiguredNameOnMap() {
        return this.nameOnMap != null ? this.nameOnMap : "";
    }

    public String getNameWithAlias() {
        return this.alias == null || this.alias.isEmpty() ? this.objectName : this.objectName + " (" + this.alias + ")";
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public ObjectCategory getCategory() {
        return this.categoryId != 0 ? this.session.getObjectCategory(this.categoryId) : null;
    }

    public ObjectStatus getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    public boolean isChildOf(long objectId) {
        if (this.parents.contains(objectId)) {
            return true;
        }
        for (Long id : this.parents) {
            AbstractObject object = this.session.findObjectById(id);
            if (object == null || !object.isChildOf(objectId)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOf(long[] objects) {
        for (long object : objects) {
            if (!this.isChildOf(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectChildOf(long objectId) {
        return this.parents.contains(objectId);
    }

    public boolean isParentOf(long objectId) {
        if (this.children.contains(objectId)) {
            return true;
        }
        for (Long id : this.children) {
            AbstractObject object = this.session.findObjectById(id);
            if (object == null || !object.isParentOf(objectId)) continue;
            return true;
        }
        return false;
    }

    public boolean isParentOf(long[] objects) {
        for (long object : objects) {
            if (!this.isParentOf(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectParentOf(long objectId) {
        return this.children.contains(objectId);
    }

    public AbstractObject[] getParentsAsArray() {
        ArrayList<AbstractObject> list = new ArrayList<AbstractObject>(this.parents.size());
        for (Long parent : this.parents) {
            AbstractObject obj = this.session.findObjectById(parent);
            if (obj == null) continue;
            list.add(obj);
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public AbstractObject[] getChildrenAsArray() {
        ArrayList<AbstractObject> list = new ArrayList<AbstractObject>(this.children.size());
        for (Long id : this.children) {
            AbstractObject obj = this.session.findObjectById(id);
            if (obj == null) continue;
            list.add(obj);
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    public long[] getChildIdList() {
        long[] list = new long[this.children.size()];
        int i = 0;
        for (Long id : this.children) {
            list[i++] = id;
        }
        return list;
    }

    public long[] getParentIdList() {
        long[] list = new long[this.parents.size()];
        int i = 0;
        for (Long id : this.parents) {
            list[i++] = id;
        }
        return list;
    }

    private void getAllChildrenInternal(int[] classFilter, Set<AbstractObject> set) {
        for (Long child : this.children) {
            AbstractObject obj = this.session.findObjectById(child);
            if (obj == null) continue;
            if (this.matchClassFilter(classFilter, obj.getObjectClass())) {
                set.add(obj);
            }
            obj.getAllChildrenInternal(classFilter, set);
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    private boolean matchClassFilter(int[] classFilter, int objectClass) {
        if (classFilter == null) {
            return true;
        }
        for (int c : classFilter) {
            if (objectClass != c) continue;
            return true;
        }
        return false;
    }

    public Set<AbstractObject> getAllChildren(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result2 = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllChildrenInternal(nArray, result2);
        return result2;
    }

    public Set<AbstractObject> getAllChildren(int[] classFilter) {
        HashSet<AbstractObject> result2 = new HashSet<AbstractObject>();
        this.getAllChildrenInternal(classFilter, result2);
        return result2;
    }

    private void getAllParentsInternal(int[] classFilter, Collection<AbstractObject> result2, boolean chain2) {
        for (Long parent : this.parents) {
            AbstractObject obj = this.session.findObjectById(parent);
            if (obj == null) continue;
            if (this.matchClassFilter(classFilter, obj.getObjectClass())) {
                result2.add(obj);
                obj.getAllParentsInternal(classFilter, result2, chain2);
                if (!chain2) continue;
                break;
            }
            obj.getAllParentsInternal(classFilter, result2, chain2);
        }
    }

    public Set<AbstractObject> getAllParents(int classFilter) {
        int[] nArray;
        HashSet<AbstractObject> result2 = new HashSet<AbstractObject>();
        if (classFilter < 0) {
            nArray = null;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = classFilter;
        }
        this.getAllParentsInternal(nArray, result2, false);
        return result2;
    }

    public Set<AbstractObject> getAllParents(int[] classFilter) {
        HashSet<AbstractObject> result2 = new HashSet<AbstractObject>();
        this.getAllParentsInternal(classFilter, result2, false);
        return result2;
    }

    public List<AbstractObject> getParentChain(int[] classFilter) {
        ArrayList<AbstractObject> chain2 = new ArrayList<AbstractObject>();
        this.getAllParentsInternal(classFilter, chain2, true);
        return chain2;
    }

    public List<AbstractObject> getTrustedNodes() {
        return this.session.findMultipleObjects(this.trustedNodes, true);
    }

    public List<AbstractObject> getDashboards(boolean accessibleOnly) {
        return this.session.findMultipleObjects(this.dashboards, true);
    }

    public boolean hasParents() {
        return this.parents.size() > 0;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean hasAccessibleChildren() {
        for (Long id : this.children) {
            if (this.session.findObjectById(id) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedOnMap() {
        return false;
    }

    public boolean isAlarmsVisible() {
        return false;
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public CustomAttribute getCustomAttribute(String name) {
        return this.customAttributes.get(name);
    }

    public String getCustomAttributeValue(String name) {
        CustomAttribute a = this.customAttributes.get(name);
        return a != null ? a.getValue() : null;
    }

    public GeoLocation getGeolocation() {
        return this.geolocation;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public UUID getMapImage() {
        ObjectCategory category;
        if (this.mapImage != null && !this.mapImage.equals(NXCommon.EMPTY_GUID)) {
            return this.mapImage;
        }
        if (this.categoryId != 0 && (category = this.session.getObjectCategory(this.categoryId)) != null) {
            return category.getMapImage();
        }
        return null;
    }

    public UUID getIcon() {
        ObjectCategory category;
        if (this.categoryId != 0 && (category = this.session.getObjectCategory(this.categoryId)) != null) {
            return category.getIcon();
        }
        return null;
    }

    public long getDrillDownObjectId() {
        return this.drillDownObjectId;
    }

    public int getStatusCalculationMethod() {
        return this.statusCalculationMethod;
    }

    public int getStatusPropagationMethod() {
        return this.statusPropagationMethod;
    }

    public ObjectStatus getFixedPropagatedStatus() {
        return this.fixedPropagatedStatus;
    }

    public int getStatusShift() {
        return this.statusShift;
    }

    public ObjectStatus[] getStatusTransformation() {
        return this.statusTransformation;
    }

    public int getStatusSingleThreshold() {
        return this.statusSingleThreshold;
    }

    public int[] getStatusThresholds() {
        return this.statusThresholds;
    }

    public final void setSession(NXCSession session) {
        this.session = session;
    }

    public int getEffectiveRights() {
        if (this.effectiveRightsCached) {
            return this.effectiveRights;
        }
        try {
            this.effectiveRights = this.session.getEffectiveRights(this.objectId);
            this.effectiveRightsCached = true;
        }
        catch (Exception e) {
            this.effectiveRights = 0;
        }
        return this.effectiveRights;
    }

    public Object getModuleData(String module) {
        return this.moduleData != null ? this.moduleData.get(module) : null;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public boolean isInMaintenanceMode() {
        return this.inMaintenanceMode;
    }

    public long getMaintenanceInitiatorId() {
        return this.maintenanceInitiatorId;
    }

    public long getPrimaryZoneProxyId() {
        return this.primaryZoneProxyId;
    }

    public long getBackupZoneProxyId() {
        return this.backupZoneProxyId;
    }

    protected static void addString(Set<String> strings, String s) {
        if (s == null) {
            return;
        }
        String ts = s.trim();
        if (!ts.isEmpty()) {
            strings.add(ts);
        }
    }

    public Set<String> getStrings() {
        HashSet<String> strings = new HashSet<String>();
        AbstractObject.addString(strings, this.comments);
        AbstractObject.addString(strings, this.objectName);
        AbstractObject.addString(strings, this.alias);
        if (this.postalAddress != null && !this.postalAddress.isEmpty()) {
            strings.add(this.postalAddress.getAddressLine());
        }
        for (CustomAttribute s : this.customAttributes.values()) {
            AbstractObject.addString(strings, s.getValue());
        }
        for (ObjectUrl u : this.urls) {
            AbstractObject.addString(strings, u.getUrl().toString());
            AbstractObject.addString(strings, u.getDescription());
        }
        return strings;
    }

    public List<ResponsibleUser> getResponsibleUsers() {
        return this.responsibleUsers;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public boolean areChildrenSynchronized() {
        return this.session.areChildrenSynchronized(this.objectId);
    }
}

