/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.configs.ChassisPlacement;
import org.netxms.client.objects.interfaces.HardwareEntity;

public class Chassis
extends DataCollectionTarget
implements HardwareEntity {
    protected long controllerId;
    protected long rackId;
    protected UUID rackImageFront;
    protected UUID rackImageRear;
    protected short rackPosition;
    protected short rackHeight;
    protected RackOrientation rackOrientation;

    public Chassis(NXCPMessage msg2, NXCSession session) {
        super(msg2, session);
        this.controllerId = msg2.getFieldAsInt64(543L);
        this.rackId = msg2.getFieldAsInt64(517L);
        this.rackImageFront = msg2.getFieldAsUUID(518L);
        this.rackImageRear = msg2.getFieldAsUUID(613L);
        this.rackPosition = msg2.getFieldAsInt16(519L);
        this.rackHeight = msg2.getFieldAsInt16(520L);
        this.rackOrientation = RackOrientation.getByValue(msg2.getFieldAsInt32(611L));
    }

    @Override
    public String getObjectClassName() {
        return "Chassis";
    }

    @Override
    public boolean isAlarmsVisible() {
        return true;
    }

    public long getControllerId() {
        return this.controllerId;
    }

    @Override
    public long getPhysicalContainerId() {
        return this.rackId;
    }

    @Override
    public UUID getFrontRackImage() {
        return this.rackImageFront;
    }

    @Override
    public UUID getRearRackImage() {
        return this.rackImageRear;
    }

    @Override
    public short getRackPosition() {
        return this.rackPosition;
    }

    @Override
    public short getRackHeight() {
        return this.rackHeight;
    }

    @Override
    public RackOrientation getRackOrientation() {
        return this.rackOrientation;
    }

    @Override
    public ChassisPlacement getChassisPlacement() {
        return null;
    }
}

