/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;

public class ClusterResource {
    private long id;
    private String name;
    private InetAddress virtualAddress;
    private long currentOwner;

    protected ClusterResource(NXCPMessage msg2, long baseId) {
        this.id = msg2.getFieldAsInt64(baseId);
        this.name = msg2.getFieldAsString(baseId + 1L);
        this.virtualAddress = msg2.getFieldAsInetAddress(baseId + 2L);
        this.currentOwner = msg2.getFieldAsInt64(baseId + 3L);
    }

    public ClusterResource(ClusterResource src) {
        this.id = src.id;
        this.name = src.name;
        this.virtualAddress = src.virtualAddress;
        this.currentOwner = src.currentOwner;
    }

    public ClusterResource(long id, String name, InetAddress virtualAddress) {
        this.id = id;
        this.name = name;
        this.virtualAddress = virtualAddress;
        this.currentOwner = 0L;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public InetAddress getVirtualAddress() {
        return this.virtualAddress;
    }

    public long getCurrentOwner() {
        return this.currentOwner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVirtualAddress(InetAddress virtualAddress) {
        this.virtualAddress = virtualAddress;
    }
}

