/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects.queries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.InputField;

public class ObjectQuery {
    private int id;
    private UUID guid;
    private String name;
    private String description;
    private String source;
    private boolean valid;
    private Map<String, InputField> inputFields;

    public ObjectQuery(String name, String description, String source) {
        this.id = 0;
        this.guid = NXCommon.EMPTY_GUID;
        this.name = name;
        this.description = description;
        this.source = source;
        this.valid = false;
        this.inputFields = new HashMap<String, InputField>();
    }

    public ObjectQuery(NXCPMessage msg2, long[] baseId) {
        long fieldId = baseId[0];
        this.id = msg2.getFieldAsInt32(fieldId++);
        this.guid = msg2.getFieldAsUUID(fieldId++);
        this.name = msg2.getFieldAsString(fieldId++);
        this.description = msg2.getFieldAsString(fieldId++);
        this.source = msg2.getFieldAsString(fieldId++);
        this.valid = msg2.getFieldAsBoolean(fieldId++);
        fieldId += 3L;
        int count2 = msg2.getFieldAsInt32(fieldId++);
        this.inputFields = new HashMap<String, InputField>(count2);
        for (int i = 0; i < count2; ++i) {
            InputField f = new InputField(msg2, fieldId);
            this.inputFields.put(f.getName(), f);
            fieldId += 10L;
        }
        baseId[0] = fieldId;
    }

    public void fillMessage(NXCPMessage msg2) {
        msg2.setFieldInt32(755L, this.id);
        msg2.setField(222L, this.guid);
        msg2.setField(20L, this.name);
        msg2.setField(27L, this.description);
        msg2.setField(208L, this.source);
        msg2.setFieldInt32(137L, this.inputFields.size());
        long fieldId = 0x10000000L;
        for (InputField f : this.inputFields.values()) {
            f.fillMessage(msg2, fieldId);
            fieldId += 10L;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<InputField> getInputFields() {
        return new ArrayList<InputField>(this.inputFields.values());
    }

    public InputField getInputField(String name) {
        return this.inputFields.get(name);
    }

    public void addInputField(InputField f) {
        this.inputFields.put(f.getName(), f);
    }

    public void removeInputField(String name) {
        this.inputFields.remove(name);
    }

    public void setInputFileds(Collection<InputField> fields) {
        this.inputFields.clear();
        for (InputField f : fields) {
            this.inputFields.put(f.getName(), f);
        }
    }
}

