/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.Date;
import org.netxms.client.TextOutputListener;

public class ServerOutputListener
implements TextOutputListener {
    private Object mutex = new Object();
    private StringBuilder buffer = new StringBuilder();
    private boolean completed = false;
    private Long streamId = 0L;
    private Date lastUpdateTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(String text) {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append(text);
            this.mutex.notifyAll();
        }
    }

    public void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError() {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append("Error occured");
            this.completed = true;
            this.mutex.notifyAll();
        }
    }

    public long getStreamId() {
        return this.streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readOutput() throws InterruptedException {
        String data;
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            while (this.buffer.length() == 0 && !this.completed) {
                this.mutex.wait();
            }
            data = this.buffer.toString();
            this.buffer = new StringBuilder();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.completed = true;
            this.mutex.notifyAll();
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

