/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.IllegalFormatException;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.MeasurementUnit;
import org.netxms.client.datacollection.TimeFormatter;

public class DataFormatter {
    private String formatString;
    private DataType dataType;
    private MeasurementUnit unit;
    private static final double[] DECIMAL_MULTIPLIERS = new double[]{1.0, 1000.0, 1000000.0, 1.0E9, 1.0E12, 1.0E15};
    private static final double[] DECIMAL_MULTIPLIERS_SMALL = new double[]{1.0E-15, 1.0E-12, 1.0E-9, 1.0E-6, 0.001, 1.0};
    private static final double[] BINARY_MULTIPLIERS = new double[]{1.0, 1024.0, 1048576.0, 1.073741824E9, 1.099511627776E12, 1.125899906842624E15};
    private static final String[] SUFFIX = new String[]{"", " k", " M", " G", " T", " P"};
    private static final String[] BINARY_SUFFIX = new String[]{"", " Ki", " Mi", " Gi", " Ti", " Pi"};
    private static final String[] SUFFIX_SMALL = new String[]{" f", " p", " n", " \u00ce\u00bc", " m", ""};

    public DataFormatter(String formatString, DataType dataType) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.unit = null;
    }

    public DataFormatter(String formatString, DataType dataType, MeasurementUnit unit) {
        this.formatString = formatString;
        this.dataType = dataType;
        this.unit = unit;
        if (formatString == null || formatString.isEmpty()) {
            this.formatString = "%{m,u}s";
        }
    }

    public String format(String value, TimeFormatter formatter) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        char[] format = this.formatString.toCharArray();
        int i = 0;
        while (i < format.length) {
            if (format[i] == '%' && i + 1 != format.length) {
                if (format[++i] == '%') {
                    sb.append('%');
                } else {
                    boolean useMultipliers = false;
                    boolean useUnits = false;
                    if (format[i] == '*') {
                        useMultipliers = true;
                    } else if (format[i] == '{' && i + 1 != format.length) {
                        int end = i;
                        while (end < format.length && format[end] != '}') {
                            ++end;
                        }
                        if (format[end] == '}' && end + 1 < format.length) {
                            if (i + 1 != end) {
                                String[] items;
                                String[] stringArray = items = new String(Arrays.copyOfRange(format, i + 1, end)).split(",");
                                int n = items.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String item = stringArray[n2];
                                    if (item.trim().compareToIgnoreCase("u") == 0 || item.trim().compareToIgnoreCase("units") == 0) {
                                        useUnits = this.unit != null;
                                    } else if (item.trim().compareToIgnoreCase("m") == 0 || item.trim().compareToIgnoreCase("multipliers") == 0) {
                                        useMultipliers = true;
                                    }
                                    ++n2;
                                }
                            }
                            i = end + 1;
                        }
                    }
                    int j = ++i;
                    while (j < format.length && !Character.isLetter(format[j])) {
                        ++j;
                    }
                    if (j + 1 < format.length && (format[j] == 't' || format[j] == 'T') && Character.isLetter(format[j + 1])) {
                        ++j;
                    }
                    String f = "%" + new String(Arrays.copyOfRange(format, i, j + 1));
                    i = j;
                    if (useUnits && this.unit.getName().equals("Uptime")) {
                        sb.append(formatter.formatUptime((long)Double.parseDouble(value)));
                    } else if (useUnits && this.unit.getName().equals("Epoch time")) {
                        sb.append(formatter.formatDateAndTime((long)Double.parseDouble(value)));
                    } else {
                        try {
                            Value v = this.getValueForFormat(value, useMultipliers, format[j] == 's' || format[j] == 'S', format[j] == 'd');
                            sb.append(String.format(f, v.value));
                            sb.append(v.suffix);
                            if (useUnits) {
                                if (v.suffix.isEmpty()) {
                                    sb.append(" ");
                                }
                                sb.append(this.unit.getName());
                            }
                        }
                        catch (IndexOutOfBoundsException | IllegalFormatException e) {
                            sb.append("<INVALID FORMAT> (");
                            sb.append(f.trim());
                            sb.append(")");
                        }
                    }
                }
            } else {
                sb.append(format[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    private Value getValueForFormat(String value, boolean useMultipliers, boolean stringOutput, boolean decimalOutput) {
        Value v;
        block17: {
            v = new Value();
            if (this.dataType != DataType.INT32 && this.dataType != DataType.UINT32 && this.dataType != DataType.COUNTER32 && this.dataType != DataType.INT64 && this.dataType != DataType.UINT64 && this.dataType != DataType.COUNTER64 && this.dataType != DataType.FLOAT) {
                v.value = value;
                return v;
            }
            try {
                if (useMultipliers) {
                    boolean isSmallNumber;
                    boolean useBinaryMultipliers = this.unit != null && this.unit.isBinary();
                    int multiplierPower = this.unit != null ? this.unit.getMultipierPower() : 0;
                    Double d = Double.parseDouble(value);
                    boolean bl = isSmallNumber = d > -0.01 && d < 0.01 && d != 0.0 && multiplierPower <= 0 && this.unit.useMultiplierForUnit() || multiplierPower < 0;
                    double[] multipliers = isSmallNumber ? DECIMAL_MULTIPLIERS_SMALL : (useBinaryMultipliers ? BINARY_MULTIPLIERS : DECIMAL_MULTIPLIERS);
                    int i = 0;
                    if (multiplierPower != 0) {
                        if (isSmallNumber) {
                            multiplierPower += 5;
                        }
                        i = Integer.min(multiplierPower, multipliers.length);
                    } else if (this.unit == null || this.unit.useMultiplierForUnit()) {
                        i = multipliers.length - 1;
                        while (i >= 0) {
                            if (!(d >= multipliers[i]) && !(d <= -multipliers[i])) {
                                --i;
                                continue;
                            }
                            break;
                        }
                    } else {
                        multipliers = DECIMAL_MULTIPLIERS;
                    }
                    if (i >= 0) {
                        if (stringOutput) {
                            NumberFormat nf = NumberFormat.getNumberInstance();
                            nf.setMaximumFractionDigits(2);
                            v.value = nf.format(d / multipliers[i]);
                        } else {
                            v.value = d / multipliers[i];
                        }
                        v.suffix = isSmallNumber ? SUFFIX_SMALL[i] : (useBinaryMultipliers ? BINARY_SUFFIX[i] : SUFFIX[i]);
                    } else {
                        v.value = stringOutput ? value : (this.dataType == DataType.FLOAT ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
                    }
                    break block17;
                }
                v.value = stringOutput ? value : (this.dataType == DataType.FLOAT ? (Number)Double.parseDouble(value) : (Number)Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                v.value = value;
            }
        }
        if (decimalOutput && v.value instanceof Double) {
            v.value = ((Double)v.value).longValue();
        }
        return v;
    }

    private static int calculatePrecision(double number) {
        int i = 0;
        if (number == 0.0 || number >= 1.0) {
            return i;
        }
        i = 1;
        while (i < 1000) {
            double d;
            number *= 10.0;
            if (d >= 1.0) break;
            ++i;
        }
        return i;
    }

    public static String roundDecimalValue(double value, double step, int maxPrecision) {
        if (value == 0.0) {
            return "0";
        }
        double absValue = Math.abs(value);
        double[] multipliers = DECIMAL_MULTIPLIERS;
        int i = multipliers.length - 1;
        while (i >= 0) {
            if (absValue >= multipliers[i]) break;
            --i;
        }
        int precision = step < 1.0 || i < 0 ? (DataFormatter.calculatePrecision(step) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step)) : (DataFormatter.calculatePrecision(step / multipliers[i]) > maxPrecision ? maxPrecision : DataFormatter.calculatePrecision(step / multipliers[i]));
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(precision);
        return String.valueOf(df.format(i < 0 ? value : value / multipliers[i])) + (i < 0 ? "" : SUFFIX[i]);
    }

    private class Value {
        Object value;
        String suffix = "";

        private Value() {
        }
    }
}

