/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerCommandExecutor
extends AbstractObjectToolExecutor
implements TextOutputListener {
    private String lastCommand = null;
    private Map<String, String> lastInputValues = null;
    private long streamId = 0L;
    private NXCSession session;
    private List<String> maskedFields;

    public ServerCommandExecutor(Composite resultArea, ViewPart viewPart, ObjectContext context, AbstractObjectToolExecutor.ActionSet actionSet, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields) {
        super(resultArea, viewPart, context, actionSet);
        this.lastInputValues = inputValues;
        this.maskedFields = maskedFields;
        this.lastCommand = tool.getData();
        this.session = ConsoleSharedData.getSession();
    }

    @Override
    protected void executeInternal(Display display) throws Exception {
        this.session.executeServerCommand(this.objectContext.object.getObjectId(), this.lastCommand, this.lastInputValues, this.maskedFields, true, (TextOutputListener)this, null);
        Messages.get();
        this.out.write(Messages.LocalCommandResults_Terminated);
    }

    @Override
    public void terminate() {
        if (this.streamId > 0L) {
            ConsoleJob job = new ConsoleJob(String.format("Stop server command for node %s", this.objectContext.object.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ServerCommandExecutor.this.session.stopServerCommand(ServerCommandExecutor.this.streamId);
                }

                protected void jobFinalize() {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ServerCommandExecutor.this.setRunning(false);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return String.format("Failed to stop server command for node %s", ServerCommandExecutor.this.objectContext.object.getObjectName());
                }
            };
            job.start();
        }
    }

    @Override
    protected boolean isTerminateSupported() {
        return true;
    }

    public void messageReceived(String text) {
        try {
            if (this.out != null) {
                this.out.write(text.replace("\r", ""));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    public void onError() {
    }
}

