/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class ColorCache
implements DisposeListener {
    private Map<RGB, Color> cache = new HashMap<RGB, Color>();

    public ColorCache() {
    }

    public ColorCache(Control control) {
        control.addDisposeListener((DisposeListener)this);
    }

    public Color create(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = this.cache.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.cache.put(rgb, color);
        }
        return color;
    }

    public Color create(int r, int g, int b) {
        return this.create(new RGB(r, g, b));
    }

    public void dispose() {
        for (Color color : this.cache.values()) {
            color.dispose();
        }
        this.cache.clear();
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }
}

