/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.UserSelectionDialog;

public class GroupMembership
extends PropertyPage {
    private TableViewer groupList;
    private NXCSession session;
    private User object;
    private HashMap<Long, AbstractUserObject> groups = new HashMap(0);

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (User)this.getElement().getAdapter(User.class);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.groupList = new TableViewer(dialogArea, 67586);
        this.groupList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.groupList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.groupList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((AbstractUserObject)e1).getName().compareToIgnoreCase(((AbstractUserObject)e2).getName());
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.groupList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.Members_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                UserSelectionDialog dlg = new UserSelectionDialog(GroupMembership.this.getShell(), UserGroup.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        GroupMembership.this.groups.put(user.getId(), user);
                        ++n2;
                    }
                    GroupMembership.this.groupList.setInput((Object)GroupMembership.this.groups.values().toArray(new AbstractUserObject[GroupMembership.this.groups.size()]));
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.Members_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = GroupMembership.this.groupList.getStructuredSelection();
                for (AbstractUserObject element : selection) {
                    if (element.getId() == 0x40000000L) continue;
                    GroupMembership.this.groups.remove(element.getId());
                }
                GroupMembership.this.groupList.setInput((Object)GroupMembership.this.groups.values().toArray());
            }
        });
        this.groupList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = GroupMembership.this.groupList.getStructuredSelection();
                deleteButton.setEnabled(!selection.isEmpty() && (selection.size() != 1 || ((AbstractUserObject)selection.getFirstElement()).getId() != 0x40000000L));
            }
        });
        long[] lArray = this.object.getGroups();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            AbstractUserObject group = this.session.findUserDBObjectById(groupId, null);
            if (group != null) {
                this.groups.put(group.getId(), group);
            }
            ++n2;
        }
        AbstractUserObject group = this.session.findUserDBObjectById(0x40000000L, null);
        if (group != null) {
            this.groups.put(group.getId(), group);
        }
        this.groupList.setInput((Object)this.groups.values().toArray());
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long[] groupIds = new long[this.groups.size()];
        int i = 0;
        for (Long id : this.groups.keySet()) {
            groupIds[i++] = id;
        }
        this.object.setGroups(groupIds);
        Messages.get();
        new ConsoleJob(Messages.Members_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                GroupMembership.this.session.modifyUserDBObject((AbstractUserObject)GroupMembership.this.object, 4096);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Members_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            GroupMembership.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

