/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.netxms.ui.eclipse.widgets.PerspectiveSwitcher;

public class SelectPerspectiveDialog
extends Dialog {
    private IPerspectiveDescriptor selectedPerspective = null;

    public SelectPerspectiveDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Initial Perspective");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.marginHeight = 20;
        layout.marginWidth = 30;
        dialogArea.setLayout((Layout)layout);
        for (final IPerspectiveDescriptor p : PerspectiveSwitcher.getVisiblePerspectives()) {
            Button button = new Button(dialogArea, 0x800008);
            button.setImage(p.getImageDescriptor().createImage());
            button.setText(p.getLabel());
            button.setFont(JFaceResources.getBannerFont());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectPerspectiveDialog.this.selectedPerspective = p;
                    SelectPerspectiveDialog.this.okPressed();
                }
            });
            GridData gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.widthHint = 500;
            button.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    public IPerspectiveDescriptor getSelectedPerspective() {
        return this.selectedPerspective;
    }
}

