/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views.helpers;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.netxms.client.InetAddressListElement;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerVariable;

public class NetworkDiscoveryConfig {
    public static final int DISCOVERY_TYPE_NONE = 0;
    public static final int DISCOVERY_TYPE_PASSIVE = 1;
    public static final int DISCOVERY_TYPE_ACTIVE = 2;
    public static final int DISCOVERY_TYPE_ACTIVE_PASSIVE = 3;
    public static final int DEFAULT_ACTIVE_INTERVAL = 7200;
    private NXCSession session;
    private int discoveryType;
    private boolean useSnmpTraps;
    private boolean useSyslog;
    private int filterFlags;
    private String filterScript;
    private int passiveDiscoveryPollInterval;
    private int activeDiscoveryPollInterval;
    private String activeDiscoveryPollSchedule;
    private List<InetAddressListElement> targets;
    private List<InetAddressListElement> addressFilter;

    private NetworkDiscoveryConfig(NXCSession session) {
        this.session = session;
    }

    public static NetworkDiscoveryConfig load(NXCSession session) throws NXCException, IOException {
        NetworkDiscoveryConfig config = new NetworkDiscoveryConfig(session);
        Map variables = session.getServerVariables();
        config.discoveryType = NetworkDiscoveryConfig.getInteger(variables, "NetworkDiscovery.Type", 0);
        config.useSnmpTraps = NetworkDiscoveryConfig.getBoolean(variables, "NetworkDiscovery.UseSNMPTraps", false);
        config.useSyslog = NetworkDiscoveryConfig.getBoolean(variables, "NetworkDiscovery.UseSyslog", false);
        config.filterFlags = NetworkDiscoveryConfig.getInteger(variables, "NetworkDiscovery.Filter.Flags", 0);
        config.filterScript = NetworkDiscoveryConfig.getString(variables, "NetworkDiscovery.Filter.Script", "none");
        config.passiveDiscoveryPollInterval = NetworkDiscoveryConfig.getInteger(variables, "NetworkDiscovery.PassiveDiscovery.Interval", 900);
        config.activeDiscoveryPollInterval = NetworkDiscoveryConfig.getInteger(variables, "NetworkDiscovery.ActiveDiscovery.Interval", 7200);
        config.activeDiscoveryPollSchedule = NetworkDiscoveryConfig.getString(variables, "NetworkDiscovery.ActiveDiscovery.Schedule", "");
        config.addressFilter = session.getAddressList(2);
        config.targets = session.getAddressList(1);
        return config;
    }

    private static boolean getBoolean(Map<String, ServerVariable> variables, String name, boolean defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue()) != 0;
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    private static int getInteger(Map<String, ServerVariable> variables, String name, int defVal) {
        ServerVariable v = variables.get(name);
        if (v == null) {
            return defVal;
        }
        try {
            return Integer.parseInt(v.getValue());
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    private static String getString(Map<String, ServerVariable> variables, String name, String defVal) {
        ServerVariable v = variables.get(name);
        return v != null ? v.getValue() : defVal;
    }

    public void save() throws NXCException, IOException {
        this.session.setServerVariable("NetworkDiscovery.Type", Integer.toString(this.discoveryType));
        this.session.setServerVariable("NetworkDiscovery.UseSNMPTraps", this.useSnmpTraps ? "1" : "0");
        this.session.setServerVariable("NetworkDiscovery.UseSyslog", this.useSyslog ? "1" : "0");
        this.session.setServerVariable("NetworkDiscovery.Filter.Flags", Integer.toString(this.filterFlags));
        this.session.setServerVariable("NetworkDiscovery.Filter.Script", this.filterScript);
        this.session.setServerVariable("NetworkDiscovery.PassiveDiscovery.Interval", Integer.toString(this.passiveDiscoveryPollInterval));
        this.session.setServerVariable("NetworkDiscovery.ActiveDiscovery.Interval", Integer.toString(this.activeDiscoveryPollInterval));
        this.session.setServerVariable("NetworkDiscovery.ActiveDiscovery.Schedule", this.activeDiscoveryPollSchedule);
        this.session.setAddressList(2, this.addressFilter);
        this.session.setAddressList(1, this.targets);
        this.session.resetServerComponent(1);
    }

    public int getFilterFlags() {
        return this.filterFlags;
    }

    public void setFilterFlags(int filterFlags) {
        this.filterFlags = filterFlags;
    }

    public String getFilterScript() {
        return this.filterScript;
    }

    public void setFilterScript(String filterScript) {
        this.filterScript = filterScript;
    }

    public List<InetAddressListElement> getTargets() {
        return this.targets;
    }

    public void setTargets(List<InetAddressListElement> targets) {
        this.targets = targets;
    }

    public List<InetAddressListElement> getAddressFilter() {
        return this.addressFilter;
    }

    public void setAddressFilter(List<InetAddressListElement> addressFilter) {
        this.addressFilter = addressFilter;
    }

    public boolean isUseSnmpTraps() {
        return this.useSnmpTraps;
    }

    public void setUseSnmpTraps(boolean useSnmpTraps) {
        this.useSnmpTraps = useSnmpTraps;
    }

    public boolean isUseSyslog() {
        return this.useSyslog;
    }

    public void setUseSyslog(boolean useSyslog) {
        this.useSyslog = useSyslog;
    }

    public int getDiscoveryType() {
        return this.discoveryType;
    }

    public void setDiscoveryType(int discoveryType) {
        this.discoveryType = discoveryType;
    }

    public int getActiveDiscoveryPollInterval() {
        return this.activeDiscoveryPollInterval;
    }

    public void setActiveDiscoveryPollInterval(int activeDiscoveryPollInterval) {
        this.activeDiscoveryPollInterval = activeDiscoveryPollInterval;
    }

    public String getActiveDiscoveryPollSchedule() {
        return this.activeDiscoveryPollSchedule;
    }

    public void setActiveDiscoveryPollSchedule(String activeDiscoveryPollSchedule) {
        this.activeDiscoveryPollSchedule = activeDiscoveryPollSchedule;
    }

    public int getPassiveDiscoveryPollInterval() {
        return this.passiveDiscoveryPollInterval;
    }

    public void setPassiveDiscoveryPollInterval(int passiveDiscoveryPollInterval) {
        this.passiveDiscoveryPollInterval = passiveDiscoveryPollInterval;
    }
}

