/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.localization;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.TimeFormatter;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateFormatFactory {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    private static I18n i18n = LocalizationHelper.getI18n(DateFormatFactory.class);
    private static int dateTimeFormat = 0;
    private static String dateFormatString;
    private static String timeFormatString;
    private static String shortTimeFormatString;
    public static final TimeFormatter TIME_FORMATTER;

    public static void updateFromPreferences() {
        PreferenceStore ps = PreferenceStore.getInstance();
        dateTimeFormat = ps.getAsInteger("DateFormatFactory.Format.DateTime", 0);
        dateFormatString = ps.getAsString("DateFormatFactory.Format.Date");
        timeFormatString = ps.getAsString("DateFormatFactory.Format.Time");
        shortTimeFormatString = ps.getAsString("DateFormatFactory.Format.ShortTime");
        if (ps.getAsBoolean("DateFormatFactory.UseServerTimeZone", false)) {
            Registry.getInstance().setServerTimeZone();
        } else {
            Registry.getInstance().resetTimeZone();
        }
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getDateFormat() + " " + session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(dateFormatString + " " + timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getDateTimeInstance(3, 2);
                }
                break;
            }
            default: {
                df = DateFormat.getDateTimeInstance(3, 2);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getDateFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(dateFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getDateInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getDateInstance(3);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getTimeInstance(2);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(2);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getShortTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getShortTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(shortTimeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getTimeInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(3);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static String formatTimeDifference(long seconds, boolean showSeconds) {
        long hours;
        StringBuilder sb = new StringBuilder();
        long days = seconds / 86400L;
        if (days > 0L) {
            sb.append(i18n.trn("{0} day", "{0} days", days));
            seconds -= days * 86400L;
        }
        if ((hours = seconds / 3600L) < 10L) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        long minutes = (seconds -= hours * 3600L) / 60L;
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        if (showSeconds) {
            sb.append(':');
            if ((seconds %= 60L) < 10L) {
                sb.append('0');
            }
            sb.append(seconds);
        }
        return sb.toString();
    }

    public static String formatTimeDifference(Date start, boolean showSeconds) {
        long seconds = (System.currentTimeMillis() - start.getTime()) / 1000L;
        return DateFormatFactory.formatTimeDifference((long)seconds, (boolean)showSeconds);
    }

    static {
        TIME_FORMATTER = new /* Unavailable Anonymous Inner Class!! */;
    }
}

