/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.modules.dashboards.config.AlarmViewerConfig;
import org.netxms.nxmc.modules.dashboards.config.BarChartConfig;
import org.netxms.nxmc.modules.dashboards.config.CustomWidgetConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DciSummaryTableConfig;
import org.netxms.nxmc.modules.dashboards.config.EmbeddedDashboardConfig;
import org.netxms.nxmc.modules.dashboards.config.EventMonitorConfig;
import org.netxms.nxmc.modules.dashboards.config.GaugeConfig;
import org.netxms.nxmc.modules.dashboards.config.GeoMapConfig;
import org.netxms.nxmc.modules.dashboards.config.LabelConfig;
import org.netxms.nxmc.modules.dashboards.config.LineChartConfig;
import org.netxms.nxmc.modules.dashboards.config.NetworkMapConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectDetailsConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectStatusChartConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectToolsConfig;
import org.netxms.nxmc.modules.dashboards.config.PieChartConfig;
import org.netxms.nxmc.modules.dashboards.config.PortViewConfig;
import org.netxms.nxmc.modules.dashboards.config.RackDiagramConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedBarChartConfig;
import org.netxms.nxmc.modules.dashboards.config.ScriptedPieChartConfig;
import org.netxms.nxmc.modules.dashboards.config.SeparatorConfig;
import org.netxms.nxmc.modules.dashboards.config.ServiceComponentsConfig;
import org.netxms.nxmc.modules.dashboards.config.SnmpTrapMonitorConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusMapConfig;
import org.netxms.nxmc.modules.dashboards.config.SyslogMonitorConfig;
import org.netxms.nxmc.modules.dashboards.config.TableBarChartConfig;
import org.netxms.nxmc.modules.dashboards.config.TablePieChartConfig;
import org.netxms.nxmc.modules.dashboards.config.TableValueConfig;
import org.netxms.nxmc.modules.dashboards.config.WebPageConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardElementConfigFactory {
    private static final Logger logger = LoggerFactory.getLogger(DashboardElementConfigFactory.class);

    public static DashboardElementConfig create(DashboardElement element) {
        try {
            switch (element.getType()) {
                case 11: {
                    return AlarmViewerConfig.createFromXml((String)element.getData());
                }
                case 2: 
                case 4: {
                    return BarChartConfig.createFromXml((String)element.getData());
                }
                case 9: {
                    return CustomWidgetConfig.createFromXml((String)element.getData());
                }
                case 7: {
                    return EmbeddedDashboardConfig.createFromXml((String)element.getData());
                }
                case 21: {
                    return DciSummaryTableConfig.createFromXml((String)element.getData());
                }
                case 13: {
                    return GaugeConfig.createFromXml((String)element.getData());
                }
                case 24: {
                    return EventMonitorConfig.createFromXml((String)element.getData());
                }
                case 10: {
                    return GeoMapConfig.createFromXml((String)element.getData());
                }
                case 0: {
                    return LabelConfig.createFromXml((String)element.getData());
                }
                case 1: {
                    return LineChartConfig.createFromXml((String)element.getData());
                }
                case 8: {
                    return NetworkMapConfig.createFromXml((String)element.getData());
                }
                case 28: {
                    return ObjectDetailsConfig.createFromXml((String)element.getData());
                }
                case 27: {
                    return ObjectToolsConfig.createFromXml((String)element.getData());
                }
                case 3: {
                    return PieChartConfig.createFromXml((String)element.getData());
                }
                case 29: {
                    return PortViewConfig.createFromXml((String)element.getData());
                }
                case 26: {
                    return RackDiagramConfig.createFromXml((String)element.getData());
                }
                case 30: {
                    return ScriptedBarChartConfig.createFromXml((String)element.getData());
                }
                case 31: {
                    return ScriptedPieChartConfig.createFromXml((String)element.getData());
                }
                case 18: {
                    return SeparatorConfig.createFromXml((String)element.getData());
                }
                case 25: {
                    return ServiceComponentsConfig.createFromXml((String)element.getData());
                }
                case 23: {
                    return SnmpTrapMonitorConfig.createFromXml((String)element.getData());
                }
                case 5: {
                    return ObjectStatusChartConfig.createFromXml((String)element.getData());
                }
                case 6: {
                    return StatusIndicatorConfig.createFromXml((String)element.getData());
                }
                case 20: {
                    return StatusMapConfig.createFromXml((String)element.getData());
                }
                case 22: {
                    return SyslogMonitorConfig.createFromXml((String)element.getData());
                }
                case 15: 
                case 17: {
                    return TableBarChartConfig.createFromXml((String)element.getData());
                }
                case 16: {
                    return TablePieChartConfig.createFromXml((String)element.getData());
                }
                case 19: {
                    return TableValueConfig.createFromXml((String)element.getData());
                }
                case 14: {
                    return WebPageConfig.createFromXml((String)element.getData());
                }
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Cannot create dashboard element configuration from element object " + element, (Throwable)e);
            e.printStackTrace();
            return null;
        }
    }
}

