/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.DciIdMatchingData;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Persister;

public class TableValueConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=true)
    private long dciId = 0L;
    @Element(required=false)
    private int refreshRate = 30;

    public static TableValueConfig createFromXml(String xml) throws Exception {
        Persister serializer = new Persister();
        return (TableValueConfig)serializer.read(TableValueConfig.class, xml);
    }

    public String createXml() throws Exception {
        Persister serializer = new Persister();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public Map<Long, Long> getDataCollectionItems() {
        HashMap<Long, Long> dcis = new HashMap<Long, Long>();
        dcis.put(this.dciId, this.objectId);
        return dcis;
    }

    public void remapDataCollectionItems(Map<Long, DciIdMatchingData> remapData) {
        super.remapDataCollectionItems(remapData);
        DciIdMatchingData md = remapData.get(this.dciId);
        if (md != null) {
            this.objectId = md.dstNodeId;
            this.dciId = md.dstDciId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }
}

