/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.NetworkMapConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.AlarmViewer;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class NetworkMap
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(AlarmViewer.class);
    private NetworkMapConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Scale zoomLevelScale;
    private Spinner zoomLevelSpinner;
    private Button enableObjectDoubleClick;

    public NetworkMap(DashboardElementConfig elementConfig) {
        super(i18n.tr("Network Map"), elementConfig);
    }

    public String getId() {
        return "network-map";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof NetworkMapConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (NetworkMapConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        this.objectSelector.setLabel(i18n.tr("Network map"));
        this.objectSelector.setObjectClass(org.netxms.client.objects.NetworkMap.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText(i18n.tr("Zoom level (%)"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.zoomLevelScale = new Scale(dialogArea, 256);
        this.zoomLevelScale.setMinimum(10);
        this.zoomLevelScale.setMaximum(400);
        this.zoomLevelScale.setSelection(this.config.getZoomLevel());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.zoomLevelScale.setLayoutData((Object)gd);
        this.zoomLevelScale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.zoomLevelSpinner = new Spinner(dialogArea, 2048);
        this.zoomLevelSpinner.setMinimum(10);
        this.zoomLevelSpinner.setMaximum(400);
        this.zoomLevelSpinner.setSelection(this.config.getZoomLevel());
        this.zoomLevelSpinner.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.enableObjectDoubleClick = new Button(dialogArea, 32);
        this.enableObjectDoubleClick.setText(i18n.tr("Enable double click &action on objects"));
        this.enableObjectDoubleClick.setSelection(this.config.isObjectDoubleClickEnabled());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setZoomLevel(this.zoomLevelSpinner.getSelection());
        this.config.setObjectDoubleClickEnabled(this.enableObjectDoubleClick.getSelection());
        return true;
    }
}

