/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusMapConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class StatusMap
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(StatusMap.class);
    private StatusMapConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Button[] checkSeverity;
    private Button checkGroupObjects;
    private Button checkHideObjectsInMaintenance;
    private Button checkShowFilter;
    private Button checkRadial;
    private Button checkFitToScreen;

    public StatusMap(DashboardElementConfig elementConfig) {
        super(i18n.tr("Status Map"), elementConfig);
    }

    public String getId() {
        return "status-map";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof StatusMapConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (StatusMapConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.objectSelector.setLabel(i18n.tr("Root object"));
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        Group severityGroup = new Group(dialogArea, 0);
        severityGroup.setText(i18n.tr("Severity filter"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        severityGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        severityGroup.setLayout((Layout)layout);
        this.checkSeverity = new Button[7];
        for (int severity = 6; severity >= 0; --severity) {
            this.checkSeverity[severity] = new Button((Composite)severityGroup, 32);
            this.checkSeverity[severity].setText(StatusDisplayInfo.getStatusText((int)severity));
            this.checkSeverity[severity].setSelection((this.config.getSeverityFilter() & 1 << severity) != 0);
        }
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        this.checkGroupObjects = new Button((Composite)optionsGroup, 32);
        this.checkGroupObjects.setText(i18n.tr("&Group objects by containers"));
        this.checkGroupObjects.setSelection(this.config.isGroupObjects());
        this.checkHideObjectsInMaintenance = new Button((Composite)optionsGroup, 32);
        this.checkHideObjectsInMaintenance.setText("Hide objects in &maintenance mode");
        this.checkHideObjectsInMaintenance.setSelection(this.config.isHideObjectsInMaintenance());
        this.checkShowFilter = new Button((Composite)optionsGroup, 32);
        this.checkShowFilter.setText(i18n.tr("Show &filter"));
        this.checkShowFilter.setSelection(this.config.isShowTextFilter());
        this.checkRadial = new Button((Composite)optionsGroup, 32);
        this.checkRadial.setText(i18n.tr("Show in &radial form"));
        this.checkRadial.setSelection(this.config.isShowRadial());
        this.checkFitToScreen = new Button((Composite)optionsGroup, 32);
        this.checkFitToScreen.setText(i18n.tr("Fit to &screen"));
        this.checkFitToScreen.setSelection(this.config.isFitToScreen());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        int severityFilter = 0;
        for (int i = 0; i < this.checkSeverity.length; ++i) {
            if (!this.checkSeverity[i].getSelection()) continue;
            severityFilter |= 1 << i;
        }
        this.config.setSeverityFilter(severityFilter);
        this.config.setGroupObjects(this.checkGroupObjects.getSelection());
        this.config.setHideObjectsInMaintenance(this.checkHideObjectsInMaintenance.getSelection());
        this.config.setShowTextFilter(this.checkShowFilter.getSelection());
        this.config.setShowRadial(this.checkRadial.getSelection());
        this.config.setFitToScreen(this.checkFitToScreen.getSelection());
        return true;
    }
}

