/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.GeoMapConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.worldmap.widgets.ObjectGeoLocationViewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoMapElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(GeoMapElement.class);
    private ObjectGeoLocationViewer mapWidget;
    private GeoMapConfig config;

    public GeoMapElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = GeoMapConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new GeoMapConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.mapWidget = new ObjectGeoLocationViewer(this.getContentArea(), 0, (View)view);
        this.mapWidget.setRootObjectId(this.getEffectiveObjectId(this.config.getRootObjectId()));
        this.mapWidget.showMap(this.config.getLatitude(), this.config.getLongitude(), this.config.getZoom());
    }
}

