/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class TestTransformationDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(TestTransformationDlg.class);
    private static final int RUN = 111;
    private DataCollectionObject object;
    private String script;
    private LabeledText inputValue;
    private CLabel status;
    private LabeledText result;
    private Image imageWaiting;

    public TestTransformationDlg(Shell parentShell, DataCollectionObject object, String script) {
        super(parentShell);
        this.object = object;
        this.script = script;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 111, i18n.tr("&Run"), true);
        b.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createButton(parent, 1, i18n.tr("Close"), false);
    }

    protected Control createDialogArea(Composite parent) {
        this.imageWaiting = ResourceManager.getImageDescriptor((String)"icons/waiting.png").createImage();
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.inputValue = new LabeledText(dialogArea, 0);
        this.inputValue.setLabel(i18n.tr("Input value"));
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.inputValue.setLayoutData((Object)gd);
        this.status = new CLabel(dialogArea, 2048);
        this.status.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.status.setText(i18n.tr("Idle"));
        this.status.setImage(StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.UNKNOWN));
        this.result = new LabeledText(dialogArea, 0);
        this.result.setLabel(i18n.tr("Result"));
        this.result.getTextControl().setEditable(false);
        this.result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return dialogArea;
    }

    private void runScript() {
        this.result.setText("");
        NXCSession session = Registry.getSession();
        AbstractObject owner = session.findObjectById(this.object.getNodeId());
        if (owner == null || !(owner instanceof DataCollectionTarget)) {
            ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createDataCollectionTargetSelectionFilter());
            dlg.setTitle("Select Execution Target");
            if (dlg.open() != 0) {
                this.status.setText("Cancelled");
                this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.MINOR));
                return;
            }
            owner = (AbstractObject)dlg.getSelectedObjects().get(0);
            if (owner == null || !(owner instanceof DataCollectionTarget)) {
                this.status.setText("Invalid execution target");
                this.status.setImage(StatusDisplayInfo.getStatusImage((Severity)Severity.CRITICAL));
                return;
            }
        }
        this.getButton(111).setEnabled(false);
        String input = this.inputValue.getText();
        this.inputValue.getTextControl().setEditable(false);
        this.status.setText(i18n.tr("Running..."));
        this.status.setImage(this.imageWaiting);
        long nodeId = owner.getObjectId();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    static /* synthetic */ Button access$000(TestTransformationDlg x0, int x1) {
        return x0.getButton(x1);
    }
}

