/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.TimePeriodSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.YAxisRangeEditor;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class GeneralChart
extends PreferencePage {
    private static final I18n i18n = LocalizationHelper.getI18n(GeneralChart.class);
    private ChartConfiguration config;
    private LabeledText title;
    private Button checkShowGrid;
    private Button checkShowLegend;
    private Button checkShowHostNames;
    private Button checkAutoRefresh;
    private Button checkLogScale;
    private Button checkStacked;
    private Button checkExtendedLegend;
    private Button checkTranslucent;
    private Button checkAreaChart;
    private Button checkUseMultipliers;
    private LabeledSpinner lineWidth;
    private Combo legendLocation;
    private Scale refreshIntervalScale;
    private Spinner refreshIntervalSpinner;
    private TimePeriodSelector timeSelector;
    private YAxisRangeEditor yAxisRange;
    private boolean saveToDatabase;

    public GeneralChart(ChartConfiguration settings, boolean saveToDatabase) {
        super("General");
        this.config = settings;
        this.saveToDatabase = saveToDatabase;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0, 2048);
        this.title.setLabel(i18n.tr("Title"));
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.verticalSpacing = 4;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.checkShowGrid = new Button((Composite)optionsGroup, 32);
        this.checkShowGrid.setText(i18n.tr("Show &grid lines"));
        this.checkShowGrid.setSelection(this.config.isGridVisible());
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        this.checkLogScale.setText(i18n.tr("L&ogarithmic scale"));
        this.checkLogScale.setSelection(this.config.isLogScale());
        this.lineWidth = new LabeledSpinner((Composite)optionsGroup, 0);
        this.lineWidth.setLabel(i18n.tr("Line width"));
        this.lineWidth.setRange(1, 99);
        this.lineWidth.setSelection(this.config.getLineWidth());
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.verticalSpan = 2;
        this.lineWidth.setLayoutData((Object)gd);
        this.checkStacked = new Button((Composite)optionsGroup, 32);
        this.checkStacked.setText(i18n.tr("Stacked"));
        this.checkStacked.setSelection(this.config.isStacked());
        this.checkTranslucent = new Button((Composite)optionsGroup, 32);
        this.checkTranslucent.setText(i18n.tr("Translucent"));
        this.checkTranslucent.setSelection(this.config.isTranslucent());
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText(i18n.tr("Show &legend"));
        this.checkShowLegend.setSelection(this.config.isLegendVisible());
        this.checkShowLegend.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkShowHostNames = new Button((Composite)optionsGroup, 32);
        this.checkShowHostNames.setText(i18n.tr("Show &host names"));
        this.checkShowHostNames.setSelection(this.config.isShowHostNames());
        this.checkShowHostNames.setEnabled(this.config.isLegendVisible());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 128;
        this.legendLocation = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)8, (String)i18n.tr("Legend position"), (Object)gd);
        this.legendLocation.add(i18n.tr("Left"));
        this.legendLocation.add(i18n.tr("Right"));
        this.legendLocation.add(i18n.tr("Top"));
        this.legendLocation.add(i18n.tr("Bottom"));
        this.legendLocation.select(31 - Integer.numberOfLeadingZeros(this.config.getLegendPosition()));
        this.legendLocation.setEnabled(this.config.isLegendVisible());
        this.checkExtendedLegend = new Button((Composite)optionsGroup, 32);
        this.checkExtendedLegend.setText(i18n.tr("Show extended legend"));
        this.checkExtendedLegend.setSelection(this.config.isExtendedLegend());
        this.checkExtendedLegend.setEnabled(this.config.isLegendVisible());
        this.checkAreaChart = new Button((Composite)optionsGroup, 32);
        this.checkAreaChart.setText(i18n.tr("Area chart"));
        this.checkAreaChart.setSelection(this.config.isArea());
        this.checkUseMultipliers = new Button((Composite)optionsGroup, 32);
        this.checkUseMultipliers.setText(i18n.tr("Use multipliers"));
        this.checkUseMultipliers.setSelection(this.config.isUseMultipliers());
        Composite refreshGroup = new Composite((Composite)optionsGroup, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        refreshGroup.setLayoutData((Object)gd);
        this.checkAutoRefresh = new Button(refreshGroup, 32);
        this.checkAutoRefresh.setText(i18n.tr("&Refresh automatically"));
        this.checkAutoRefresh.setSelection(this.config.isAutoRefresh());
        this.checkAutoRefresh.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite refreshIntervalGroup = new Composite(refreshGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshIntervalGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshIntervalGroup.setLayoutData((Object)gd);
        Label label = new Label(refreshIntervalGroup, 0);
        label.setText(i18n.tr("Refresh interval:"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.refreshIntervalScale = new Scale(refreshIntervalGroup, 256);
        this.refreshIntervalScale.setMinimum(1);
        this.refreshIntervalScale.setMaximum(600);
        this.refreshIntervalScale.setSelection(this.config.getRefreshRate());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshIntervalScale.setLayoutData((Object)gd);
        this.refreshIntervalScale.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshIntervalScale.setEnabled(this.config.isAutoRefresh());
        this.refreshIntervalSpinner = new Spinner(refreshIntervalGroup, 2048);
        this.refreshIntervalSpinner.setMinimum(1);
        this.refreshIntervalSpinner.setMaximum(600);
        this.refreshIntervalSpinner.setSelection(this.config.getRefreshRate());
        this.refreshIntervalSpinner.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshIntervalSpinner.setEnabled(this.config.isAutoRefresh());
        Group timeSelectorGroup = new Group(dialogArea, 0);
        timeSelectorGroup.setText(i18n.tr("Time Period"));
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        timeSelectorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        timeSelectorGroup.setLayoutData((Object)gd);
        this.timeSelector = new TimePeriodSelector((Composite)timeSelectorGroup, 0, this.config.getTimePeriod());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.timeSelector.setLayoutData((Object)gd);
        this.yAxisRange = new YAxisRangeEditor(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.yAxisRange.setLayoutData((Object)gd);
        this.yAxisRange.setSelection(this.config.isAutoScale(), this.config.isModifyYBase(), this.config.getMinYScaleValue(), this.config.getMaxYScaleValue());
        return dialogArea;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.title.setText("");
        this.checkShowGrid.setSelection(true);
        this.checkShowLegend.setSelection(true);
        this.checkShowHostNames.setSelection(false);
        this.checkAutoRefresh.setSelection(true);
        this.checkLogScale.setSelection(false);
        this.checkStacked.setSelection(false);
        this.checkExtendedLegend.setSelection(false);
        this.checkAreaChart.setSelection(false);
        this.checkUseMultipliers.setSelection(true);
        this.legendLocation.select(3);
        this.lineWidth.setSelection(2);
        this.yAxisRange.setSelection(true, false, 0.0, 100.0);
        this.refreshIntervalScale.setSelection(30);
        this.refreshIntervalSpinner.setSelection(30);
        this.timeSelector.setDefaults();
    }

    protected void applyChanges(boolean isApply) {
        this.config.setTitle(this.title.getText());
        this.config.setGridVisible(this.checkShowGrid.getSelection());
        this.config.setLegendVisible(this.checkShowLegend.getSelection());
        this.config.setAutoScale(this.yAxisRange.isAuto());
        this.config.setShowHostNames(this.checkShowHostNames.getSelection());
        this.config.setAutoRefresh(this.checkAutoRefresh.getSelection());
        this.config.setLogScale(this.checkLogScale.getSelection());
        this.config.setRefreshRate(this.refreshIntervalSpinner.getSelection());
        this.config.setStacked(this.checkStacked.getSelection());
        this.config.setExtendedLegend(this.checkExtendedLegend.getSelection());
        this.config.setArea(this.checkAreaChart.getSelection());
        this.config.setLegendPosition((int)Math.pow(2.0, this.legendLocation.getSelectionIndex()));
        this.config.setTranslucent(this.checkTranslucent.getSelection());
        this.config.setLineWidth(this.lineWidth.getSelection());
        this.config.setTimePeriod(this.timeSelector.getTimePeriod());
        this.config.setUseMultipliers(this.checkUseMultipliers.getSelection());
        this.config.setMinYScaleValue(this.yAxisRange.getMinY());
        this.config.setMaxYScaleValue(this.yAxisRange.getMaxY());
        this.config.setModifyYBase(this.yAxisRange.modifyYBase());
        if (this.saveToDatabase && isApply) {
            this.setValid(false);
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected void performApply() {
        if (this.isControlCreated() && this.yAxisRange.validate(true)) {
            this.applyChanges(true);
        }
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        if (!this.yAxisRange.validate(true)) {
            return false;
        }
        this.applyChanges(false);
        return true;
    }
}

