/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciValue;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.xnap.commons.i18n.I18n;

public class SummaryTableGeneral
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(SummaryTableGeneral.class);
    private DciSummaryTable table;
    private LabeledText menuPath;
    private LabeledText title;
    private LabeledText dciName;
    private Button importButton;

    public SummaryTableGeneral(DciSummaryTable table) {
        super(i18n.tr("General"));
        this.table = table;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.menuPath = new LabeledText(dialogArea, 0);
        this.menuPath.setLabel(i18n.tr("Menu path"));
        this.menuPath.setText(this.table.getMenuPath());
        this.menuPath.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel(i18n.tr("Title"));
        this.title.setText(this.table.getTitle());
        this.title.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.table.isTableSoure()) {
            this.dciName = new LabeledText(dialogArea, 0);
            this.dciName.setLabel("DCI name");
            this.dciName.getTextControl().setTextLimit(255);
            this.dciName.setText(this.table.getTableDciName());
            this.dciName.setLayoutData((Object)new GridData(4, 128, true, false));
            this.importButton = new Button(dialogArea, 8);
            this.importButton.setText("Import...");
            GridData gd = new GridData();
            gd.verticalAlignment = 1024;
            gd.widthHint = 90;
            this.importButton.setLayoutData((Object)gd);
            this.importButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return dialogArea;
    }

    private void selectDci() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        dlg.setDcObjectType(2);
        dlg.setSingleSelection(true);
        if (dlg.open() == 0) {
            this.table.setTableDciName(((DciValue)dlg.getSelection().get(0)).getName());
            this.dciName.setText(this.table.getTableDciName());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        this.table.setMenuPath(this.menuPath.getText());
        this.table.setTitle(this.title.getText());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

