/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.views.helpers.LastValuesComparator;
import org.xnap.commons.i18n.I18n;

public class LastValuesComparator
extends ViewerComparator {
    private static I18n i18n = LocalizationHelper.getI18n(LastValuesComparator.class);
    private boolean showErrors = true;

    public int compare(Viewer viewer, Object e1, Object e2) {
        TableColumn sortColumn = ((SortableTableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        DciValue v1 = (DciValue)e1;
        DciValue v2 = (DciValue)e2;
        int result = 0;
        switch ((Integer)sortColumn.getData("ID")) {
            case 0: {
                AbstractObject obj1 = Registry.getSession().findObjectById(v1.getNodeId());
                AbstractObject obj2 = Registry.getSession().findObjectById(v2.getNodeId());
                String name1 = obj1 != null ? obj1.getObjectName() : "[" + Long.toString(v1.getNodeId()) + "]";
                String name2 = obj2 != null ? obj2.getObjectName() : "[" + Long.toString(v2.getNodeId()) + "]";
                result = name1.compareToIgnoreCase(name2);
                break;
            }
            case 1: {
                result = (int)(v1.getId() - v2.getId());
                break;
            }
            case 2: {
                result = v1.getDescription().compareToIgnoreCase(v2.getDescription());
                break;
            }
            case 3: {
                result = this.compareValue(v1, v2);
                break;
            }
            case 4: {
                result = v1.getTimestamp().compareTo(v2.getTimestamp());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private int compareValue(DciValue dci1, DciValue dci2) {
        String v2;
        DataType dt2;
        String v1;
        DataType dt1;
        if (this.showErrors && dci1.getErrorCount() > 0) {
            dt1 = DataType.STRING;
            v1 = i18n.tr("<< ERROR >>");
        } else if (dci1.getDcObjectType() == 2) {
            dt1 = DataType.STRING;
            v1 = i18n.tr("<< TABLE >>");
        } else {
            dt1 = dci1.getDataType();
            v1 = dci1.getValue();
        }
        if (this.showErrors && dci2.getErrorCount() > 0) {
            dt2 = DataType.STRING;
            v2 = i18n.tr("<< ERROR >>");
        } else if (dci2.getDcObjectType() == 2) {
            dt2 = DataType.STRING;
            v2 = i18n.tr("<< TABLE >>");
        } else {
            dt2 = dci2.getDataType();
            v2 = dci2.getValue();
        }
        DataType dataType = DataType.getTypeForCompare((DataType)dt1, (DataType)dt2);
        try {
            switch (1.$SwitchMap$org$netxms$client$constants$DataType[dataType.ordinal()]) {
                case 1: {
                    return Integer.signum(Integer.parseInt(v1) - Integer.parseInt(v2));
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return Long.signum(Long.parseLong(v1) - Long.parseLong(v2));
                }
                case 7: {
                    return (int)Math.signum(Double.parseDouble(v1) - Double.parseDouble(v2));
                }
            }
            return v1.compareToIgnoreCase(v2);
        }
        catch (NumberFormatException e) {
            return v1.compareToIgnoreCase(v2);
        }
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

