/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.events.ActionExecutionConfiguration;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ActionExecutionConfigurationDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(ActionExecutionConfigurationDialog.class);
    private ActionExecutionConfiguration configuration;
    private LabeledText timerDelay;
    private LabeledText timerKey;
    private LabeledText snoozeTime;
    private LabeledText blockingTimerKey;

    public ActionExecutionConfigurationDialog(Shell parentShell, ActionExecutionConfiguration configuration) {
        super(parentShell);
        this.configuration = configuration;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Action Execution Configuration"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.timerDelay = new LabeledText(dialogArea, 0);
        this.timerDelay.setLabel(this.i18n.tr("Delay"));
        this.timerDelay.setText(this.configuration.getTimerDelay());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 200;
        this.timerDelay.setLayoutData((Object)gd);
        this.timerKey = new LabeledText(dialogArea, 0);
        this.timerKey.setLabel(this.i18n.tr("Delay timer key"));
        this.timerKey.setText(this.configuration.getTimerKey());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.timerKey.setLayoutData((Object)gd);
        this.snoozeTime = new LabeledText(dialogArea, 0);
        this.snoozeTime.setLabel(this.i18n.tr("Snooze time"));
        this.snoozeTime.setText(this.configuration.getSnoozeTime());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.snoozeTime.setLayoutData((Object)gd);
        this.blockingTimerKey = new LabeledText(dialogArea, 0);
        this.blockingTimerKey.setLabel(this.i18n.tr("Snooze/blocking timer key (Do not run action if this timer exists)"));
        this.blockingTimerKey.setText(this.configuration.getBlockingTimerKey());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        this.blockingTimerKey.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.configuration.setTimerDelay(this.timerDelay.getText().trim());
        this.configuration.setTimerKey(this.timerKey.getText().trim());
        this.configuration.setSnoozeTime(this.snoozeTime.getText().trim());
        this.configuration.setBlockingTimerKey(this.blockingTimerKey.getText().trim());
        super.okPressed();
    }
}

