/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.server.RemoteFile;
import org.netxms.nxmc.resources.ResourceManager;

public class BaseFileLabelProvider
extends LabelProvider {
    private static Map<String, Image> images = new HashMap();

    public Image getImage(Object element) {
        if (((RemoteFile)element).isPlaceholder()) {
            return null;
        }
        if (((RemoteFile)element).isDirectory()) {
            return (Image)images.get("folder");
        }
        String[] parts = ((RemoteFile)element).getName().split("\\.");
        if (parts.length < 2) {
            return (Image)images.get("unknown");
        }
        String ext = parts[parts.length - 1];
        if (ext.equalsIgnoreCase("exe")) {
            return (Image)images.get("exe");
        }
        if (ext.equalsIgnoreCase("pdf")) {
            return (Image)images.get("pdf");
        }
        if (ext.equalsIgnoreCase("xls") || ext.equalsIgnoreCase("xlsx")) {
            return (Image)images.get("xls");
        }
        if (ext.equalsIgnoreCase("ppt") || ext.equalsIgnoreCase("pptx")) {
            return (Image)images.get("ppt");
        }
        if (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm")) {
            return (Image)images.get("html");
        }
        if (ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("log") || ext.equalsIgnoreCase("jrn")) {
            return (Image)images.get("txt");
        }
        if (ext.equalsIgnoreCase("avi") || ext.equalsIgnoreCase("mkv") || ext.equalsIgnoreCase("mov") || ext.equalsIgnoreCase("wma")) {
            return (Image)images.get("avi");
        }
        if (ext.equalsIgnoreCase("ac3") || ext.equalsIgnoreCase("mp3") || ext.equalsIgnoreCase("wav")) {
            return (Image)images.get("ac3");
        }
        if (ext.equalsIgnoreCase("tar") || ext.equalsIgnoreCase("gz") || ext.equalsIgnoreCase("tgz") || ext.equalsIgnoreCase("zip") || ext.equalsIgnoreCase("rar") || ext.equalsIgnoreCase("7z") || ext.equalsIgnoreCase("bz2") || ext.equalsIgnoreCase("lzma")) {
            return (Image)images.get("tar");
        }
        return (Image)images.get("unknown");
    }

    public String getText(Object element) {
        return ((RemoteFile)element).getName();
    }

    protected static String getSizeString(long size) {
        if (size >= 0xA0000000000L) {
            return String.format("%.1f TB", (double)size / 1.099511627776E12);
        }
        if (size >= 0x280000000L) {
            return String.format("%.1f GB", (double)size / 1.073741824E9);
        }
        if (size >= 0xA00000L) {
            return String.format("%.1f MB", (double)size / 1048576.0);
        }
        if (size >= 10240L) {
            return String.format("%.1f KB", (double)size / 1024.0);
        }
        return Long.toString(size);
    }

    static {
        images.put("folder", ResourceManager.getImageDescriptor((String)"icons/folder.gif").createImage());
        images.put("unknown", ResourceManager.getImageDescriptor((String)"icons/types/unknown.png").createImage());
        images.put("exe", ResourceManager.getImageDescriptor((String)"icons/types/exec.png").createImage());
        images.put("pdf", ResourceManager.getImageDescriptor((String)"icons/types/pdf.png").createImage());
        images.put("xls", ResourceManager.getImageDescriptor((String)"icons/types/excel.png").createImage());
        images.put("ppt", ResourceManager.getImageDescriptor((String)"icons/types/powerpoint.png").createImage());
        images.put("html", ResourceManager.getImageDescriptor((String)"icons/types/html.png").createImage());
        images.put("txt", ResourceManager.getImageDescriptor((String)"icons/types/text.png").createImage());
        images.put("avi", ResourceManager.getImageDescriptor((String)"icons/types/video.png").createImage());
        images.put("ac3", ResourceManager.getImageDescriptor((String)"icons/types/audio.png").createImage());
        images.put("tar", ResourceManager.getImageDescriptor((String)"icons/types/archive.png").createImage());
    }
}

